use crate::pkg::err::Result;
use byteorder::{LittleEndian, WriteBytesExt};
use std::collections::HashMap;
use std::io::Write;
use std::str::FromStr;

#[derive(Default, Debug, Clone)]
pub struct Gtid(HashMap<String, Vec<(i64, i64)>>);

impl Gtid {
    pub fn encode(&self) -> Result<Vec<u8>> {
        let mut gtid_data = vec![0u8; 0];
        gtid_data.write_u64::<LittleEndian>(self.0.len() as u64)?;
        for (id, range) in &self.0 {
            let uid = uuid::Uuid::from_str(id)?;
            gtid_data.write_all(uid.as_bytes())?;
            gtid_data.write_i64::<LittleEndian>(range.len() as i64)?;
            for i_item in range {
                gtid_data.write_i64::<LittleEndian>(i_item.0)?;
                gtid_data.write_i64::<LittleEndian>(i_item.1)?;
            }
        }
        Ok(gtid_data)
    }
    // todo
    pub fn update_gitd(&mut self, _other: &Gtid) {}
}
impl<S: AsRef<str>> From<S> for Gtid {
    fn from(input: S) -> Gtid {
        let mut rsl: HashMap<String, Vec<(i64, i64)>> = Default::default();
        for data in input.as_ref().trim().split(',') {
            match parse_uuid_start_ends(data) {
                Ok(d) => rsl.insert(d.0, d.1),
                Err(_e) => continue,
            };
        }
        Gtid(rsl)
    }
}
fn parse_uuid_start_ends<S: AsRef<str>>(input: S) -> Result<(String, Vec<(i64, i64)>)> {
    let mut split_count = -1;
    let mut rsl: (String, Vec<(i64, i64)>) = ("".to_string(), vec![]);
    for data in input.as_ref().trim().split(':') {
        split_count += 1;
        if split_count == 0 {
            rsl.0 = data.to_string();
        } else {
            let mut range = (0, 0);
            let mut s_count = -1;
            for data_ in data.trim().split('-') {
                s_count += 1;
                if s_count == 0 {
                    range.0 = data_.parse::<i64>()?;
                } else {
                    range.1 = data_.parse::<i64>()?
                }
            }
            rsl.1.push(range);
        }
    }
    Ok(rsl)
}

#[test]
fn test_gtid_from() {
    let g = Gtid::from("58e3d520-98aa-11ea-a85e-5254000fe6fe:9667-79602:79728-193549030:193549032-193550029:193550031-193550630:193550632-193550919:193550921-193551088:193551090-193554332:193554334-193554637:193554639-193554784:193554786-193554991:193554993-193555087:193555089-193555319:193555321-193555469:193555471-193555612:193555614-193555708:193555710-193555905:193555907-193556230:193556232-193556719:193556721-193557094:193557096-193557675:193557677-193558227:193558229-193558396:193558398-193558701:193558703-193558828:193558830-193558973:193558975-193559171:193559173-193829032:193829034-193829910:193829912-193830463:193830465-193830673:193830675-193830867:193830869-193833841:193833843-193834053:193834055-193834321:193834323-193834434:193834436-193834566:193834568-193834829:193834831-193835021:193835023-193835147:193835149-193835273:193835275-193835428:193835430-193835765:193835767-193836261:193836263-193836597:193836599-193837179:193837181-193837765:193837767-193837921:193837923-193838221:193838223-193838392:193838394-193838527:193838529-193838650:193838652-194527521:194527523-194537380:194537382-194538912:194538914-194540180:194540182-194541302:194541304-194542165:194542167-194542704:194542706-194543046:194543048-194543306:194543308-194543512:194543514-194549189:194549191-194553017:194553019-194553566:194553568-194553885:194553887-194554112:194554114-194554399:194554401-194554612:194554614-194554802:194554804-194554999:194555001-194555153:194555155-194555647:194555649-194555951:194555953-194556242:194556244-194556431:194556433-194556631:194556633-194556778:194556780-194556986:194556988-194557192:194557194-194557550:194557552-194557829:194557831-194558417:194558419-194558789:194558791-194559605:194559607-194560216:194560218-194560609:194560611-194560983:194560985-194561763:194561765-194562514:194562516-194563274:194563276-194564107:194564109-194564278:194564280-194564522:194564524-194564749:194564751-194565042:194565044-194565221:194565223-194565373:194565375-194565567:194565569-194565817:194565819-194566037:194566039-194566317:194566319-343607297,75786ebb-9020-11ea-81bd-5254000fe6fe:1-946681812");
    dbg!(g.encode().unwrap());
    dbg!(g);
}
