use std::env;
use std::process;
use myminigrep::Config;

fn main() {
    let config = Config::new(env::args()).unwrap_or_else(|error| {
        eprintln!("Problem parsing arguments: {}", error);
        process::exit(1);
    });

    if let Err(e) = myminigrep::run(config) {
        eprintln!("Application error : {}", e);
        process::exit(1);
    }
}


