use std::collections::BTreeMap;
use std::env;

pub type Arguments = BTreeMap<String, ArgumentTypes>;

#[derive(Debug, Clone)]
pub enum ArgumentTypes {
    WithoutArguments,
    WithArguments(Vec<String>),
}

pub fn parse_arguments(args: Vec<String>) -> Arguments {
    let mut arguments: Arguments = BTreeMap::new();
    let alength = args.len();

    for argument in args.iter().enumerate() {
        let (index, value) = argument;

        if value.starts_with("--") {
            let argument_head = value.clone().replace("--", "");
            let args = args[index..alength]
                .iter()
                .filter(|arg| arg.starts_with('-') != true)
                .map(|val| val.clone())
                .collect::<Vec<String>>();

            arguments.insert(argument_head.clone(), ArgumentTypes::WithArguments(args));
        } else if value.starts_with("-") {
            let argument = value.clone().replace("-", "");
            arguments.insert(argument.clone(), ArgumentTypes::WithoutArguments);
        }
    }

    arguments
}

pub fn get_runtime_arguments() -> Vec<String> {
    let mut args = env::args().collect::<Vec<String>>();

    args.remove(0);

    return args;
}
