use super::defaults;
use super::parser::Arguments;
use super::types;

pub fn navigate(runtime_arguments: Arguments, _templates: Vec<super::configuration::Template>) {
    let mut pages = defaults::PAGES();
    let method_args: types::FunctionArguments = (runtime_arguments.clone(), _templates.clone());

    if runtime_arguments.is_empty() {
        let help_page = pages
            .iter()
            .find(|page| page.0.contains(&"help".to_string()))
            .clone();

        if help_page.is_none() {
            panic!("No Help Page found");
        }

        help_page.expect("Help Page").1.as_ref()(method_args);
        return;
    }

    for page in pages.iter_mut() {
        for alias in page.0.clone() {
            if runtime_arguments.contains_key(&alias) {
                let function = page.1.as_mut();

                function(method_args);

                return;
            }
        }
    }

    println!("No Page found")
}
