use std::io::Write;

mod configuration;
mod defaults;
mod navigation;
mod pages;
mod types;
mod utils;

extern crate bincode;
extern crate serde;
extern crate toml;

use {
    runtime_argument_parser::parser,
    std::{fs, path::Path},
};

fn main() {
    let installed_dir = std::env::args()
        .collect::<Vec<String>>()
        .get(0)
        .expect("Can not read the programs path")
        .clone();

    let config_path = format!(
        "{}{}",
        installed_dir[0..installed_dir.len() - 19].to_string(),
        "pm.config"
    );

    if !Path::new(&config_path).exists() {
        println!("Creating Config ...");

        if !Path::new(&defaults::DEFAULT_TEMPLATE_PATH).exists() {
            fs::create_dir_all(&defaults::DEFAULT_TEMPLATE_PATH).unwrap();
        }

        let configuaration =
            configuration::Configuration::new(defaults::DEFAULT_TEMPLATE_PATH.to_string());

        let mut file = fs::File::create(&config_path).unwrap();

        file.write_all(&configuaration.to_binary().unwrap())
            .unwrap();
        file.flush().unwrap();
    }

    let config = utils::get_config(config_path);
    let runargs = parser::parse_arguments(parser::get_runtime_arguments());
    let templates: Vec<configuration::Template> = utils::get_templates(
        config
            .expect("Failed to read and deserialize the Config")
            .template_dir,
    );

    navigation::navigate(runargs, templates);
}
