#![allow(non_snake_case)]

use super::{pages, types};

pub fn PAGES() -> Vec<types::PageDefinition> {
    vec![
        (
            vec!["help".to_string(), "h".to_string()],
            Box::new(pages::help_page),
        ),
        (
            vec!["list_projects".to_string(), "lp".to_string()],
            Box::new(pages::list_projects),
        ),
        (
            vec!["create_project".to_string(), "cp".to_string()],
            Box::new(pages::create_project),
        ),
        (
            vec!["delete_project".to_string(), "dp".to_string()],
            Box::new(pages::delete_project),
        ),
        (
            vec!["open_project".to_string(), "op".to_string()],
            Box::new(pages::open_project),
        ),
        (
            vec!["list_templates".to_string(), "lt".to_string()],
            Box::new(pages::list_templates),
        ),
        (
            vec!["create_template".to_string(), "ct".to_string()],
            Box::new(pages::create_template),
        ),
        (
            vec!["get_template".to_string(), "gt".to_string()],
            Box::new(pages::get_template),
        ),
        (
            vec!["delete_template".to_string(), "dt".to_string()],
            Box::new(pages::delete_template),
        ),
        (
            vec!["create_dummy_template".to_string(), "cdt".to_string()],
            Box::new(pages::create_dummy_template),
        ),
    ]
}

pub const DEFAULT_TEMPLATE_PATH: &str = "\\project-templates\\";
