/// Authorized user.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct User {
    /// Identifier of the user
    #[prost(string, tag = "1")]
    pub id: std::string::String,
    /// Auth0 generated user name
    #[prost(string, tag = "2")]
    pub user: std::string::String,
    /// Public display name
    #[prost(string, tag = "3")]
    pub display_name: std::string::String,
    /// Valid url string to the profile picture
    #[prost(string, tag = "4")]
    pub profile_picture: std::string::String,
    /// Date-time that the user was created
    #[prost(message, optional, tag = "5")]
    pub created_at: ::std::option::Option<::prost_types::Timestamp>,
    /// Date-time that the user was updated
    #[prost(message, optional, tag = "6")]
    pub updated_at: ::std::option::Option<::prost_types::Timestamp>,
}
