/// The social network engagement information.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Engagement {
    #[prost(uint32, tag = "1")]
    pub share_count: u32,
}
/// Label attached to the post for the purpose of identification or classification.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Taxonomy {
    /// Identifier of the taxonomy
    #[prost(string, tag = "1")]
    pub id: std::string::String,
    /// Name of the taxonomy
    #[prost(string, tag = "2")]
    pub name: std::string::String,
    /// Valid url string composes with name and id
    #[prost(string, tag = "3")]
    pub slug: std::string::String,
    /// Term group (e.g. category or tag)
    #[prost(string, tag = "4")]
    pub term_group: std::string::String,
}
/// Piece of content in the blog platform.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Post {
    /// Identifier of the post
    #[prost(string, tag = "1")]
    pub id: std::string::String,
    /// Title of the post
    #[prost(string, tag = "2")]
    pub title: std::string::String,
    /// Valid url string composes with title and id
    #[prost(string, tag = "3")]
    pub slug: std::string::String,
    /// Status of the post which could be...
    /// - Draft
    /// - Published
    #[prost(enumeration = "PostStatus", tag = "4")]
    pub status: i32,
    /// Original content of the post in markdown syntax
    #[prost(string, tag = "5")]
    pub markdown: std::string::String,
    /// Content of the post in HTML format which will be translated from markdown
    #[prost(string, tag = "6")]
    pub html: std::string::String,
    /// Date-time that the post was published
    #[prost(message, optional, tag = "7")]
    pub published_at: ::std::option::Option<::prost_types::Timestamp>,
    /// Identifier of the author
    #[prost(message, optional, tag = "8")]
    pub author: ::std::option::Option<super::auth::User>,
    /// List of categories that the post belonging to
    #[prost(message, repeated, tag = "9")]
    pub categories: ::std::vec::Vec<Taxonomy>,
    /// List of tags that the post belonging to
    #[prost(message, repeated, tag = "10")]
    pub tags: ::std::vec::Vec<Taxonomy>,
    /// A featured image to be shown at the archive page as a cover image
    #[prost(message, optional, tag = "11")]
    pub featured_image: ::std::option::Option<super::storage::File>,
    /// List of attachment (image, video, document, etc.) are belonging to the post
    #[prost(message, repeated, tag = "12")]
    pub attachments: ::std::vec::Vec<super::storage::File>,
    /// Date-time that the post was created
    #[prost(message, optional, tag = "14")]
    pub created_at: ::std::option::Option<::prost_types::Timestamp>,
    /// Date-time that the post was updated
    #[prost(message, optional, tag = "15")]
    pub updated_at: ::std::option::Option<::prost_types::Timestamp>,
}
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
#[repr(i32)]
pub enum PostStatus {
    Draft = 0,
    Published = 1,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ListPublishedPostsRequest {
    #[prost(uint32, tag = "1")]
    pub offset: u32,
    #[prost(uint32, tag = "2")]
    pub limit: u32,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ListPublishedPostsResponse {
    #[prost(message, repeated, tag = "1")]
    pub posts: ::std::vec::Vec<Post>,
}
#[doc = r" Generated server implementations."]
pub mod blog_service_server {
    #![allow(unused_variables, dead_code, missing_docs)]
    use tonic::codegen::*;
    #[doc = "Generated trait containing gRPC methods that should be implemented for use with BlogServiceServer."]
    #[async_trait]
    pub trait BlogService: Send + Sync + 'static {
        async fn list_published_posts(
            &self,
            request: tonic::Request<super::ListPublishedPostsRequest>,
        ) -> Result<tonic::Response<super::ListPublishedPostsResponse>, tonic::Status>;
    }
    #[doc = " The blog service definition."]
    #[derive(Debug)]
    pub struct BlogServiceServer<T: BlogService> {
        inner: _Inner<T>,
    }
    struct _Inner<T>(Arc<T>, Option<tonic::Interceptor>);
    impl<T: BlogService> BlogServiceServer<T> {
        pub fn new(inner: T) -> Self {
            let inner = Arc::new(inner);
            let inner = _Inner(inner, None);
            Self { inner }
        }
        pub fn with_interceptor(inner: T, interceptor: impl Into<tonic::Interceptor>) -> Self {
            let inner = Arc::new(inner);
            let inner = _Inner(inner, Some(interceptor.into()));
            Self { inner }
        }
    }
    impl<T, B> Service<http::Request<B>> for BlogServiceServer<T>
    where
        T: BlogService,
        B: HttpBody + Send + Sync + 'static,
        B::Error: Into<StdError> + Send + 'static,
    {
        type Response = http::Response<tonic::body::BoxBody>;
        type Error = Never;
        type Future = BoxFuture<Self::Response, Self::Error>;
        fn poll_ready(&mut self, _cx: &mut Context<'_>) -> Poll<Result<(), Self::Error>> {
            Poll::Ready(Ok(()))
        }
        fn call(&mut self, req: http::Request<B>) -> Self::Future {
            let inner = self.inner.clone();
            match req.uri().path() {
                "/myblog.proto.blog.BlogService/ListPublishedPosts" => {
                    #[allow(non_camel_case_types)]
                    struct ListPublishedPostsSvc<T: BlogService>(pub Arc<T>);
                    impl<T: BlogService>
                        tonic::server::UnaryService<super::ListPublishedPostsRequest>
                        for ListPublishedPostsSvc<T>
                    {
                        type Response = super::ListPublishedPostsResponse;
                        type Future = BoxFuture<tonic::Response<Self::Response>, tonic::Status>;
                        fn call(
                            &mut self,
                            request: tonic::Request<super::ListPublishedPostsRequest>,
                        ) -> Self::Future {
                            let inner = self.0.clone();
                            let fut = async move { (*inner).list_published_posts(request).await };
                            Box::pin(fut)
                        }
                    }
                    let inner = self.inner.clone();
                    let fut = async move {
                        let interceptor = inner.1.clone();
                        let inner = inner.0;
                        let method = ListPublishedPostsSvc(inner);
                        let codec = tonic::codec::ProstCodec::default();
                        let mut grpc = if let Some(interceptor) = interceptor {
                            tonic::server::Grpc::with_interceptor(codec, interceptor)
                        } else {
                            tonic::server::Grpc::new(codec)
                        };
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                _ => Box::pin(async move {
                    Ok(http::Response::builder()
                        .status(200)
                        .header("grpc-status", "12")
                        .body(tonic::body::BoxBody::empty())
                        .unwrap())
                }),
            }
        }
    }
    impl<T: BlogService> Clone for BlogServiceServer<T> {
        fn clone(&self) -> Self {
            let inner = self.inner.clone();
            Self { inner }
        }
    }
    impl<T: BlogService> Clone for _Inner<T> {
        fn clone(&self) -> Self {
            Self(self.0.clone(), self.1.clone())
        }
    }
    impl<T: std::fmt::Debug> std::fmt::Debug for _Inner<T> {
        fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
            write!(f, "{:?}", self.0)
        }
    }
    impl<T: BlogService> tonic::transport::NamedService for BlogServiceServer<T> {
        const NAME: &'static str = "myblog.proto.blog.BlogService";
    }
}
