//! # My public library crate
//! `my_pub_crate`는 다양한 연산 기능을 가진 함수를 포함한다. <br>
//! `강조`하고 싶을 땐 \` `사이에 내용을 쓴다` \` <br>
//! 코드를 감쌀 때는 \``` 사이에 내용을 쓴다 \```
//! ```
//! let var = 0;
//! ```

/// 주어진 자연수에 2를 더한다
/// # Examples
/// ```
/// let v = 10;
/// let answer = my_pub_lib_proj::add_two(v);
/// assert_eq!(12, answer);
/// ```
pub fn add_two(x: i32) -> i32 {
    x+2
}

/// 더하기 등 연산 함수를 구현할 예정이다.
pub mod operators {
    /// 주어진 자연수에 1을 더한다
    /// # Examples
    /// ```
    /// let v = 10;
    /// let answer = my_pub_lib_proj::operators::add_one(v);
    /// assert_eq!(11, answer);
    /// ```
    /// # Panics
    /// 0보다 작은 값이 입력될 경우 패닉이 발생한다.
    pub fn add_one(x: i32) -> i32 {
        if x < 1 {
            panic!("범위 밖의 값이 입력되었습니다.");
        }
        x+1
    }
}
