## 0.3.3 / 2021-12-16
* Fix fields on EditResponse type

## 0.3.2 / 2021-11-21
* Fix accidental inversion of mark_as_bot option.
* Avoid having a `parsoid::Wikicode` in scope over an await.

## 0.3.1 / 2021-11-19
* Fix panic when dealing with invalid titles. Fixes [#33](https://gitlab.com/mwbot-rs/mwbot/-/issues/33).
* Fix {{nobots}} implementation.

## 0.3.0 / 2021-11-14
* An `oauth2_token` can be used in `mwbot.toml` for authentication. This is
  preferred over a bot password because it doesn't require an explit login
  request. Fixes [#8](https://gitlab.com/mwbot-rs/mwbot/-/issues/8).
* Add `mwbot.toml` option to ignore {{nobots}} named `respect_nobots`.
* Overhaul how pages are saved. Generally it is now:
  `page.save(code, &SaveOptions::summary("edit summary")).await?`. A `String`
  of wikitext can also be used. More options like whether to mark the edit
  as bot or change tags to add can be controlled via the new `SaveOptions`.
  Fixes [#18](https://gitlab.com/mwbot-rs/mwbot/-/issues/18).
  * The prep_saving_ functions have been removed.
* Legacy errors from action=edit will now return Error::UnknownSaveFailure.
  Fixes [#9](https://gitlab.com/mwbot-rs/mwbot/-/issues/9).
* Add generators to get all pages in a category and that use a template.
  Fixes [#22](https://gitlab.com/mwbot-rs/mwbot/-/issues/22).

## 0.3.0-alpha.7 / 2021-11-07
* Reuse `mwapi`'s HTTP client for `parsoid`. Requires 0.6.1 of `parsoid`.
* Add `Page::get_redirect_target()` to get a page's redirect target.
* Check file permissions on `mwbot.toml` are not obviously misconfigured. It
  will error if the file is world readable, and in some cases, group readable.
  Fixes [#5](https://gitlab.com/mwbot-rs/mwbot/-/issues/5).
* Normalize username used in User-agent header.

## 0.3.0-alpha.6 / 2021-11-01
* Require ^0.6 of `parsoid`.

## 0.3.0-alpha.5 / 2021-11-01
* Require `tokio` ^1.8.0 for functionality used in the edit throttle.
* Remove `Page::new()`, `Bot::get_page()` must be used instead.
* Require a minimum of Rust 1.56.

## 0.3.0-alpha.4 / 2021-10-21
* Overhaul how edits work
  * Require edits to be prepared before they can be saved. This allows for
    setting different flags/parameters when saving the edit.
  * Implement an edit throttle, which defaults to 6 edits/minute.
  * Allow setting `mark_as_bot` and `save_delay` in mwbot.toml under an
   `[edit]` section.
* Have Bot implement `Clone` and `Debug`.

## 0.3.0-alpha.3 / 2021-10-18
* Add `Page::save_wikitext()`
* Use new `mwapi_errors` crate for the Error type. Errors from `Bot::from_*`
  functions implement a new `ConfigError`.

## 0.3.0-alpha.2 / 2021-10-14
* Make authentication optional
* Implement specific error types instead of `anyhow::Error`.
* Implement `{{nobots}}` support.

## 0.3.0-alpha.1 / 2021-10-13
* Initial alpha release
