/*
Copyright (C) 2021 Kunal Mehta <legoktm@debian.org>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

use serde::Deserialize;

/// Config file
#[derive(Deserialize)]
pub(crate) struct Config {
    pub(crate) api_url: String,
    pub(crate) rest_url: String,
    pub(crate) auth: Option<Auth>,
    #[serde(default)]
    pub(crate) edit: EditOptions,
}

/// Login information (BotPassword)
#[derive(Deserialize)]
pub(crate) struct Auth {
    pub(crate) username: String,
    pub(crate) password: String,
}

#[derive(Default, Deserialize)]
pub(crate) struct EditOptions {
    pub(crate) mark_as_bot: Option<bool>,
    pub(crate) save_delay: Option<u64>,
}
