/*
Copyright (C) 2021 Kunal Mehta <legoktm@debian.org>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

//! A MediaWiki API client library.
//!
//! Key features of mwapi:
//! * generic to fit any application, whether for interactive usage
//!   or writing a bot
//! * intended for use in async setups, and is compatible with being
//!   used with concurrency
//! * turns MediaWiki errors into Rust errors for you
//! * logging (using the `log` crate) for visiblity into errors
//!
//! More to come.
pub mod client;
pub mod error;
mod responses;
mod tokens;

const VERSION: &str = env!("CARGO_PKG_VERSION");

/// API Client
pub use client::Client;
pub use error::{Error, ErrorFormat};

pub type Result<T> = std::result::Result<T, Error>;
