#!/bin/bash

set -eu

echo "Running beam_calcs (Rust example)"
time ../target/release/examples/beam_calcs 10 --hdf5-file ../mwa_full_embedded_element_pattern.h5
echo ""

echo "Running beam_calcs_cuda (Rust example)"
time ../target/release/examples/beam_calcs_cuda 10 --hdf5-file ../mwa_full_embedded_element_pattern.h5
echo ""

for py_example in *.py; do
    echo "Running ${py_example}"
    time "./${py_example}"
    echo ""
done

for c_example in *.c; do
    echo "Compiling and running ${c_example}"
    gcc -O3 -D SINGLE -I ../include -L ../target/release/ -l mwa_hyperbeam "${c_example}" -o "/tmp/${c_example}"
    time LD_LIBRARY_PATH=../target/release "/tmp/${c_example}" ../mwa_full_embedded_element_pattern.h5
    echo ""
done

for cu_example in *.cu; do
    echo "Compiling and running ${cu_example}"
    nvcc -O3 -D SINGLE -I ../include -L ../target/release/ -l mwa_hyperbeam "${cu_example}" -o "/tmp/${cu_example}"
    time LD_LIBRARY_PATH=../target/release "/tmp/${cu_example}" ../mwa_full_embedded_element_pattern.h5
    echo ""
done
