#!/bin/bash

set -eu

for py_example in *.py; do
    echo "Running ${py_example}"
    time "./${py_example}"
    echo ""
done

for c_example in *.c; do
    echo "Compiling and running ${c_example}"
    gcc -O3 -I ../include -L ../target/release/ -l mwa_hyperbeam "${c_example}" -o "/tmp/${c_example}"
    time LD_LIBRARY_PATH=../target/release "/tmp/${c_example}" ../mwa_full_embedded_element_pattern.h5
    echo ""
done
