use super::c_bindings::{tSdkFrameHead, CameraHandle, BYTE, PVOID};
use super::{status::CamFail, CamRes};

/// Pass instance of this enum to Camera::set_img_format to change image format
/// # Example
/// ```
/// let mut camera = Camera::new().unwrap();
/// camera.set_img_format(CamImgFormat::MONO16).unwrap(); // grayscale, 16bit image
/// ```
#[derive(Debug)]
pub enum CamImgFormat {
    MONO = 16777216,
    RGB = 33554432,
    CUSTOM = 2147483648,
    COLOR_MASK = 4278190080,
    OCCUPY1BIT = 65536,
    OCCUPY2BIT = 131072,
    OCCUPY4BIT = 262144,
    OCCUPY8BIT = 524288,
    OCCUPY10BIT = 655360,
    OCCUPY12BIT = 786432,
    OCCUPY16BIT = 1048576,
    OCCUPY24BIT = 1572864,
    OCCUPY32BIT = 2097152,
    OCCUPY36BIT = 2359296,
    OCCUPY48BIT = 3145728,
    OCCUPY64BIT = 4194304,
    EFFECTIVE_PIXEL_SIZE_MASK = 16711680,
    EFFECTIVE_PIXEL_SIZE_SHIFT = 16,
    ID_MASK = 65535,
    COUNT = 70,
    MONO1P = 16842807,
    MONO2P = 16908344,
    MONO4P = 17039417,
    MONO8 = 17301505,
    MONO8S = 17301506,
    MONO10 = 17825795,
    MONO10_PACKED = 17563652,
    MONO12 = 17825797,
    MONO12_PACKED = 17563654,
    MONO14 = 17825829,
    MONO16 = 17825799,
    BAYGR8 = 17301512,
    BAYRG8 = 17301513,
    BAYGB8 = 17301514,
    BAYBG8 = 17301515,
    BAYGR10_MIPI = 17432614,
    BAYRG10_MIPI = 17432615,
    BAYGB10_MIPI = 17432616,
    BAYBG10_MIPI = 17432617,
    BAYGR10 = 17825804,
    BAYRG10 = 17825805,
    BAYGB10 = 17825806,
    BAYBG10 = 17825807,
    BAYGR12 = 17825808,
    BAYRG12 = 17825809,
    BAYGB12 = 17825810,
    BAYBG12 = 17825811,
    BAYGR10_PACKED = 17563686,
    BAYRG10_PACKED = 17563687,
    BAYGB10_PACKED = 17563688,
    BAYBG10_PACKED = 17563689,
    BAYGR12_PACKED = 17563690,
    BAYRG12_PACKED = 17563691,
    BAYGB12_PACKED = 17563692,
    BAYBG12_PACKED = 17563693,
    BAYGR16 = 17825838,
    BAYRG16 = 17825839,
    BAYGB16 = 17825840,
    BAYBG16 = 17825841,
    RGB8 = 35127316,
    BGR8 = 35127317,
    RGBA8 = 35651606,
    BGRA8 = 35651607,
    RGB10 = 36700184,
    BGR10 = 36700185,
    RGB12 = 36700186,
    BGR12 = 36700187,
    RGB16 = 36700211,
    BGR16 = 36700235,
    RGBA16 = 37748836,
    BGRA16 = 37748817,
    RGB10V1_PACKED = 35651612,
    RGB10P32 = 35651613,
    RGB12V1_PACKED = 35913780,
    RGB565P = 34603061,
    BGR565P = 34603062,
    YUV411_8_UYYVYY = 34340894,
    YUV422_8_UYVY = 34603039,
    YUV422_8 = 34603058,
    YUV8_UYV = 35127328,
    YCBCR8_CBYCR = 35127354,
    YCBCR422_8 = 34603067,
    YCBCR422_8_CBYCRY = 34603075,
    YCBCR411_8_CBYYCRYY = 34340924,
    YCBCR601_8_CBYCR = 35127357,
    YCBCR601_422_8 = 34603070,
    YCBCR601_422_8_CBYCRY = 34603076,
    YCBCR601_411_8_CBYYCRYY = 34340927,
    YCBCR709_8_CBYCR = 35127360,
    YCBCR709_422_8 = 34603073,
    YCBCR709_422_8_CBYCRY = 34603077,
    YCBCR709_411_8_CBYYCRYY = 34340930,
    RGB8_PLANAR = 35127329,
    RGB10_PLANAR = 36700194,
    RGB12_PLANAR = 36700195,
    RGB16_PLANAR = 36700196,
    BAYGR12_PACKED_MV = 17563744,
    BAYRG12_PACKED_MV = 17563745,
    BAYGB12_PACKED_MV = 17563746,
    BAYBG12_PACKED_MV = 17563747,
    MONO12_PACKED_MV = 17563748,
    YUV420P_MV = 34340965,
}

impl CamImgFormat {
    pub fn from_raw(fmt: u32) -> CamRes<CamImgFormat> {
        match fmt {
            16777216 => Ok(CamImgFormat::MONO),
            33554432 => Ok(CamImgFormat::RGB),
            2147483648 => Ok(CamImgFormat::CUSTOM),
            4278190080 => Ok(CamImgFormat::COLOR_MASK),
            65536 => Ok(CamImgFormat::OCCUPY1BIT),
            131072 => Ok(CamImgFormat::OCCUPY2BIT),
            262144 => Ok(CamImgFormat::OCCUPY4BIT),
            524288 => Ok(CamImgFormat::OCCUPY8BIT),
            655360 => Ok(CamImgFormat::OCCUPY10BIT),
            786432 => Ok(CamImgFormat::OCCUPY12BIT),
            1048576 => Ok(CamImgFormat::OCCUPY16BIT),
            1572864 => Ok(CamImgFormat::OCCUPY24BIT),
            2097152 => Ok(CamImgFormat::OCCUPY32BIT),
            2359296 => Ok(CamImgFormat::OCCUPY36BIT),
            3145728 => Ok(CamImgFormat::OCCUPY48BIT),
            4194304 => Ok(CamImgFormat::OCCUPY64BIT),
            16711680 => Ok(CamImgFormat::EFFECTIVE_PIXEL_SIZE_MASK),
            16 => Ok(CamImgFormat::EFFECTIVE_PIXEL_SIZE_SHIFT),
            65535 => Ok(CamImgFormat::ID_MASK),
            70 => Ok(CamImgFormat::COUNT),
            16842807 => Ok(CamImgFormat::MONO1P),
            16908344 => Ok(CamImgFormat::MONO2P),
            17039417 => Ok(CamImgFormat::MONO4P),
            17301505 => Ok(CamImgFormat::MONO8),
            17301506 => Ok(CamImgFormat::MONO8S),
            17825795 => Ok(CamImgFormat::MONO10),
            17563652 => Ok(CamImgFormat::MONO10_PACKED),
            17825797 => Ok(CamImgFormat::MONO12),
            17563654 => Ok(CamImgFormat::MONO12_PACKED),
            17825829 => Ok(CamImgFormat::MONO14),
            17825799 => Ok(CamImgFormat::MONO16),
            17301512 => Ok(CamImgFormat::BAYGR8),
            17301513 => Ok(CamImgFormat::BAYRG8),
            17301514 => Ok(CamImgFormat::BAYGB8),
            17301515 => Ok(CamImgFormat::BAYBG8),
            17432614 => Ok(CamImgFormat::BAYGR10_MIPI),
            17432615 => Ok(CamImgFormat::BAYRG10_MIPI),
            17432616 => Ok(CamImgFormat::BAYGB10_MIPI),
            17432617 => Ok(CamImgFormat::BAYBG10_MIPI),
            17825804 => Ok(CamImgFormat::BAYGR10),
            17825805 => Ok(CamImgFormat::BAYRG10),
            17825806 => Ok(CamImgFormat::BAYGB10),
            17825807 => Ok(CamImgFormat::BAYBG10),
            17825808 => Ok(CamImgFormat::BAYGR12),
            17825809 => Ok(CamImgFormat::BAYRG12),
            17825810 => Ok(CamImgFormat::BAYGB12),
            17825811 => Ok(CamImgFormat::BAYBG12),
            17563686 => Ok(CamImgFormat::BAYGR10_PACKED),
            17563687 => Ok(CamImgFormat::BAYRG10_PACKED),
            17563688 => Ok(CamImgFormat::BAYGB10_PACKED),
            17563689 => Ok(CamImgFormat::BAYBG10_PACKED),
            17563690 => Ok(CamImgFormat::BAYGR12_PACKED),
            17563691 => Ok(CamImgFormat::BAYRG12_PACKED),
            17563692 => Ok(CamImgFormat::BAYGB12_PACKED),
            17563693 => Ok(CamImgFormat::BAYBG12_PACKED),
            17825838 => Ok(CamImgFormat::BAYGR16),
            17825839 => Ok(CamImgFormat::BAYRG16),
            17825840 => Ok(CamImgFormat::BAYGB16),
            17825841 => Ok(CamImgFormat::BAYBG16),
            35127316 => Ok(CamImgFormat::RGB8),
            35127317 => Ok(CamImgFormat::BGR8),
            35651606 => Ok(CamImgFormat::RGBA8),
            35651607 => Ok(CamImgFormat::BGRA8),
            36700184 => Ok(CamImgFormat::RGB10),
            36700185 => Ok(CamImgFormat::BGR10),
            36700186 => Ok(CamImgFormat::RGB12),
            36700187 => Ok(CamImgFormat::BGR12),
            36700211 => Ok(CamImgFormat::RGB16),
            36700235 => Ok(CamImgFormat::BGR16),
            37748836 => Ok(CamImgFormat::RGBA16),
            37748817 => Ok(CamImgFormat::BGRA16),
            35651612 => Ok(CamImgFormat::RGB10V1_PACKED),
            35651613 => Ok(CamImgFormat::RGB10P32),
            35913780 => Ok(CamImgFormat::RGB12V1_PACKED),
            34603061 => Ok(CamImgFormat::RGB565P),
            34603062 => Ok(CamImgFormat::BGR565P),
            34340894 => Ok(CamImgFormat::YUV411_8_UYYVYY),
            34603039 => Ok(CamImgFormat::YUV422_8_UYVY),
            34603058 => Ok(CamImgFormat::YUV422_8),
            35127328 => Ok(CamImgFormat::YUV8_UYV),
            35127354 => Ok(CamImgFormat::YCBCR8_CBYCR),
            34603067 => Ok(CamImgFormat::YCBCR422_8),
            34603075 => Ok(CamImgFormat::YCBCR422_8_CBYCRY),
            34340924 => Ok(CamImgFormat::YCBCR411_8_CBYYCRYY),
            35127357 => Ok(CamImgFormat::YCBCR601_8_CBYCR),
            34603070 => Ok(CamImgFormat::YCBCR601_422_8),
            34603076 => Ok(CamImgFormat::YCBCR601_422_8_CBYCRY),
            34340927 => Ok(CamImgFormat::YCBCR601_411_8_CBYYCRYY),
            35127360 => Ok(CamImgFormat::YCBCR709_8_CBYCR),
            34603073 => Ok(CamImgFormat::YCBCR709_422_8),
            34603077 => Ok(CamImgFormat::YCBCR709_422_8_CBYCRY),
            34340930 => Ok(CamImgFormat::YCBCR709_411_8_CBYYCRYY),
            35127329 => Ok(CamImgFormat::RGB8_PLANAR),
            36700194 => Ok(CamImgFormat::RGB10_PLANAR),
            36700195 => Ok(CamImgFormat::RGB12_PLANAR),
            36700196 => Ok(CamImgFormat::RGB16_PLANAR),
            17563744 => Ok(CamImgFormat::BAYGR12_PACKED_MV),
            17563745 => Ok(CamImgFormat::BAYRG12_PACKED_MV),
            17563746 => Ok(CamImgFormat::BAYGB12_PACKED_MV),
            17563747 => Ok(CamImgFormat::BAYBG12_PACKED_MV),
            17563748 => Ok(CamImgFormat::MONO12_PACKED_MV),
            34340965 => Ok(CamImgFormat::YUV420P_MV),
            _ => Err(CamFail::PARAMETER_INVALID),
        }
    }
}

/// Pass instance of this enum to Camera::set_trigger_mode to choose trigger mode
/// # Example
/// ```
/// let mut camera = Camera::new().unwrap();
/// camera.set_trigger_mode(TriggerMode::SoftWareTrigger).unwrap();
/// ```
#[derive(Debug)]
pub enum TriggerMode {
    Acquisition = 0,
    SoftWareTrigger = 1,
    HardWareTrigger = 2,
}

impl TriggerMode {
    pub fn from_raw(mode: i32) -> CamRes<TriggerMode> {
        match mode {
            0 => Ok(TriggerMode::Acquisition),
            1 => Ok(TriggerMode::SoftWareTrigger),
            2 => Ok(TriggerMode::HardWareTrigger),
            _ => Err(CamFail::PARAMETER_INVALID),
        }
    }
}

#[derive(Debug)]
pub enum LutMode {
    PARAM_GEN = 0,
    PRESET = 1,
    USER_DEF = 2,
}

impl LutMode {
    pub fn from_raw(mode: i32) -> CamRes<LutMode> {
        match mode {
            0 => Ok(LutMode::PARAM_GEN),
            1 => Ok(LutMode::PRESET),
            2 => Ok(LutMode::USER_DEF),
            _ => Err(CamFail::PARAMETER_INVALID),
        }
    }
}

pub type RAW_CALLBACK = unsafe extern "C" fn(
    hCamera: CameraHandle,
    pFrameBuffer: *mut BYTE,
    pFrameHead: *mut tSdkFrameHead,
    pContext: PVOID,
);
