Muter is a tool to convert to and from various data formats, such as
hexadecimal, Base64, and URI encoding.

# Use

Muter takes a series of bytes like cat (as filenames or from standard
input) and produces a byte sequence to standard out. The bytes are
modified by the argument to -c (--chain) that specifies the encodings to
perform.

For example, a chain of `-hex:base64` decodes hex input and then
re-encodes the data in Base64. `base64:uri` would Base64-encode the
data, and then URI-encode it, but `url64` would just encode using the
URL-safe version of Base64. A chain of `hash(sha256):hex` would hash the
input data and then hex-encode the SHA-256 hash.

Muter is written in Rust and supports Rust 1.34.2 or newer. You can
simply run `cargo build --release` to build it. If you’d like to build
the documentation, install Asciidoctor and GNU make, and type `make all
doc`, and the man page will be in `doc/`. The help output is also
generally helpful.

While Muter lacks translations, it is designed to be localized. Please
open an issue if you’re interested in submitting a translation.

If you’re looking for the older Perl version, you can find it in the
`perl` branch.

# Examples

``` shell-session
# URI-decode some data, then HTML-encode it
$ muter -c -uri:xml,html my-data >foo.html

# Generate a subresource integrity hash
$ printf 'sha256-'; \
  curl -s https://code.jquery.com/jquery-3.2.1.js | muter -c hash,sha256:base64
sha256-DZAnKJ/6XZ9si04Hgrsxu/8s717jcIzLy3oi35EouyE=

# Encode a password for use with curl
$ curl https://user:$(printf 'very-complex/pass' | muter -c uri)@example.org
```

# Transforms

The following transforms are available, many with multiple options:

  - ascii85

  - base16

  - base32

  - base32hex

  - base64

  - bubblebabble

  - checksum

  - crlf

  - deflate

  - form

  - gzip

  - hash

  - hex

  - identity

  - lf

  - modhex

  - quotedprintable

  - uri

  - url64

  - uuencode

  - vis

  - wrap

  - xml

  - zlib

For a full description of the transforms that are available, see [the
manual page](doc/man/muter.adoc).

If you’re interested in a new transform, feel free to open an issue.
Note that we try to ensure that transforms are deterministic and that
they round-trip if there’s a reverse variant, but sometimes we make
exceptions. We also generally prefer that the decoder encode all
variants that the encoders can produce without any arguments.

# Name

Muter comes from the Spanish verb *mudar* and the French verb *muter*,
meaning *to mutate*, since what it does is, well, mutate data.

The name is pronounced /ˈmjuːtər/ (MEW-ter).
