use std::fs::File;
use std::io::Write;
//use std::result::Result;

use actix_cors::Cors;
use actix_files::{self};
use actix_web::{get, post, web, App, HttpRequest, HttpResponse, HttpServer, Responder};
use actix_web::http::StatusCode;
//use actix_web_httpauth::extractors::AuthenticationError;
//use actix_web_httpauth::extractors::bearer::{BearerAuth, Config};
//use actix_web_httpauth::middleware::HttpAuthentication;
use chrono::Utc;
use futures::StreamExt;
use futures::stream::TryStreamExt;
//use jsonwebtoken::{decode, encode, EncodingKey, Header, Validation};
use mongodb::Client;
//use mongodb::{Client, Collection};
use mongodb::bson::doc;
use mongodb::options::ClientOptions;
//use rand::{SeedableRng, Fill};
//use rand::rngs::StdRng;
use uuid::Uuid;

mod app_data;
use app_data::AppData;

//mod claims;
//use claims::Claims;

mod file_record;
use file_record::FileRecord;

/*fn new_secret() -> [u8; 64] {
    let mut rng = StdRng::from_entropy();
    let mut output = [0; 64];
    output.try_fill(&mut rng).unwrap();
    return output;
}*/

#[get("/download/{file:.*}")]
async fn get_file(request: HttpRequest, app_data: web::Data<AppData>) -> impl Responder {
    let path_str = request.match_info().query("file");
    println!("{}", path_str);
    let collection = app_data.database.collection::<FileRecord>("files");
    let mut matches: Vec<FileRecord> = collection
        .find(doc! { "name": path_str }, None).await.unwrap()
        .try_collect().await.unwrap();
    println!("{:?}", matches);
    matches.sort_unstable_by_key(|file_record| file_record.upload_time);
    println!("{:?}", matches);
    return actix_files::NamedFile::open(&matches.last().unwrap().stored_as);
}

#[post("/upload/{file:.*}")]
async fn post_file(request: HttpRequest, mut body: actix_multipart::Multipart, app_data: web::Data<AppData>) -> impl Responder {
    println!("file upload request received: {:?}", request);
    let stored_name = Uuid::new_v4().to_string();
    let mut file_to_write = File::create(&stored_name).unwrap();
    while let Ok(Some(mut field)) = body.try_next().await {
        println!("field found");
        while let Some(chunk) = field.next().await {
            println!("writing chunk");
            let data = chunk.unwrap();
            file_to_write = web::block(move || file_to_write.write_all(&data).map(|_| file_to_write)).await.unwrap().unwrap();
        }
    }

    let path = request.match_info().query("file");
    if path == "" {
        return HttpResponse::BadRequest().status(StatusCode::BAD_REQUEST).body("Filename must be provided in URL");
    }

    let collection = app_data.database.collection::<FileRecord>("files");
    let file_record = FileRecord::new(path.to_string(), stored_name, Utc::now().naive_utc());
    collection.insert_one(file_record, None).await.unwrap();
    return HttpResponse::Accepted().body("File added to repository");
}

#[get("/")]
async fn base() -> impl Responder {
    /*let secret = base64::encode(new_secret());
    let claims = Claims::new("all".to_string());
    let token = encode(
        &Header::default(),
        &claims,
        &EncodingKey::from_base64_secret(&secret).unwrap()).unwrap();
    HttpResponse::Ok().body(format!("<h1>{}.{}<br/>{:?}</h1>", token, secret, claims))*/
    HttpResponse::Ok().body("<h1>Really?</h1>")
}

/*async fn bearer_authentication_validator(request: ServiceRequest, credentials: BearerAuth) -> Result<ServiceRequest, Error> {
    if request.head().method == Method::GET {
        return Ok(request);
    }
    let config = request.app_data::<Config>()
        .map(|data| data.clone())
        .unwrap_or_else(Default::default);

    return match validate_token(credentials.token()) {
        Ok(valid) => {
            if valid {
                Ok(request)
            }
            else {
                Err(AuthenticationError::from(config).into())
            }
        }
        Err(_) => Err(AuthenticationError::from(config).into())
    }
}

fn validate_token(token: &str) -> Result<bool, std::io::Error> {
    ////let decoded_token = decode(token);
    return Ok(true);
}*/

#[actix_web::main]
async fn main() -> std::io::Result<()> {
    let database_options = ClientOptions::parse("mongodb://localhost:27017").await.unwrap();
    HttpServer::new(move || {
        let database = Client::with_options(database_options.clone()).unwrap().database("music_book");
        let app_data = web::Data::new(AppData::new(database));
        App::new()
            .wrap(Cors::default().allow_any_origin().allow_any_method().allow_any_header())
            .app_data(app_data)
            ////.service(web::scope("/upload")
                ////.wrap(HttpAuthentication::bearer(bearer_authentication_validator)))
            .service(base)
            .service(post_file)
            .service(get_file)
    })
        .bind(("127.0.0.1", 33333))?
        .run()
        .await
}
