use chrono::naive::NaiveDateTime;
use serde::{Deserialize, Serialize};

#[derive(Debug, Serialize, Deserialize)]
pub struct FileRecord {
    pub name: String,
    pub stored_as: String,
    pub upload_time: NaiveDateTime,
}

impl FileRecord {
    pub fn new(name: String, stored_as: String, upload_time: NaiveDateTime) -> Self {
        Self {
            name,
            stored_as,
            upload_time,
        }
    }
}