use cursive::traits::View;
use cursive::Printer;
use cursive::Vec2;
use cursive::theme::{Color, ColorStyle,BaseColor};

// custom divider views
pub struct HDivider{
    height: usize
}

impl HDivider {
    pub fn new() -> HDivider {
        HDivider {
            height: 0
        }
    }
}

impl View for HDivider {
    fn draw(&self, printer: &Printer) {
        let size = printer.size;
        for i in 0..size.y {
            printer.print((0,i),"│")
        }
    }

    fn required_size(&mut self,constraint: Vec2) -> Vec2 {
        self.height = constraint.y;
        Vec2::new(1,constraint.y)
    }
}

pub struct VDivider{
    pub width: usize
}

impl VDivider {
    pub fn new() -> VDivider {
        VDivider{
            width: 0
        }
    }
}

impl View for VDivider {
    fn draw(&self, printer: &Printer) {
        let size = printer.size;
        for i in 0..size.x {
            printer.print((i,0),"─")
        }
    }

    fn required_size(&mut self,constraint: Vec2) -> Vec2 {
        self.width = constraint.x;
        Vec2::new(constraint.x,1)
    }
}

// custom view for a playback progress bar
pub struct PlaybackProgress {
    pub width: usize,
    cur_length: usize,
    total_length: usize
}

impl PlaybackProgress {
    pub fn update(&mut self, length: usize, total: usize) {
        self.total_length = total;
        self.cur_length = length;
    }
    pub fn new() -> PlaybackProgress {
        PlaybackProgress {
            width: 0,
            cur_length: 0,
            total_length: 0
        }
    }
}

impl View for PlaybackProgress {
    fn draw(&self, printer: &Printer) {
        if self.total_length == 0 {
            return;
        }
        let style = ColorStyle::new(
            Color::Light(BaseColor::Green),
            Color::TerminalDefault
        );
        let size = printer.size;
        for i in 0..size.x {
            printer.print((i,0),"─")
        }
        let to_fill_f = size.x as f64* (self.cur_length as f64 / self.total_length as f64);
        let to_fill = to_fill_f as usize;
        for i in 0..to_fill {
            printer.with_color(style, |p|{
                p.print((i,0),"=");

                if i == to_fill-1 {
                    p.print((i,0),">");
                }
            });
        }
    }

    fn required_size(&mut self,constraint: Vec2) -> Vec2 {
        self.width = constraint.x;
        if self.total_length == 0 {
            return Vec2::new(0, 0);
        }
        Vec2::new(constraint.x,1)
    }
}