use cpal;
use cpal::traits::{DeviceTrait, HostTrait, StreamTrait};
use cpal::{Data, Sample, SampleFormat};
use std::fs::File;
use lewton::inside_ogg::OggStreamReader;
use std::thread;

// this is a work in progress
// this is intended to eventually replace alto with cpal
fn play_vorbis_stream<F: Into<String>>(file: F) {
    let file_str = file.into();
    let f = File::open(&file_str).expect(&format!("Where is this file again?\n{}",&file_str)[..]);
    let mut source = OggStreamReader::new(f).unwrap();
    if source.ident_hdr.audio_channels > 2 {
        eprintln!("Stream error: {} channels are too many!", source.ident_hdr.audio_channels);
    }

    let host = cpal::default_host();
    let device = host.default_output_device().expect("no output device available");
    let config = device.default_output_config().unwrap();
    let sample_rate = source.ident_hdr.audio_sample_rate as i32;
    let sample_format = config.sample_format();
    println!("{:?}",sample_format);

    let bob_the_builder = thread::Builder::new().name("audio".to_string());
    bob_the_builder.spawn(move ||{
        let stream = device.build_output_stream(
            &config.into(),

            move |data: &mut [i16], _| {
                while let Some(pck_samples) = source.read_dec_packet_itl().unwrap() {
                    let mut count = 0;
                    for sample in data.iter_mut() {
                        if count >= pck_samples.len() {
                            break;
                        }
                        println!("{}",sample);
                        //println!("{}",pck_samples[count]);
                        *sample = Sample::from(&pck_samples[count]);
                        count += 1;
                    }
                }
            },
            |err| eprintln!("Oh shit! Error: {}", err)
        ).unwrap();
        stream.play().expect("Why isn't the music playing?!");
        loop{}

    }).expect("Unable to spawn audio thread!");
}