[![Crates.io](https://img.shields.io/crates/v/music-lounge)](https://crates.io/crates/music-lounge)
[![AUR version](https://img.shields.io/aur/version/music-lounge)](https://aur.archlinux.org/packages/music-lounge/)
# Music Lounge
![](icon.png)

Music Lounge is yet another music player program for Unix-like systems. It will be the default music player for Aercloud OS. Due to the fact that the alto library outputs messages to the console, Music Lounge must be ran as `mlounge>/dev/null` otherwise, the UI will become mangled.

# Screenshots

## Main UI
![](screenshots/library.png)

# How to install

## Arch Linux based Linux systems
Music Lounge is available in the AUR for Arch Linux and any system based on it (like Manjaro Linux, EndeavourOS, and Artix Linux)

Installation example using `yay`: `yay -S music-lounge`

## Other Linux and Unix-like systems

Make sure you have the latest version of Rust installed

Instructions on how to install it are [here](https://rustup.rs/)

### Using cargo (rust's package manager)
Simply run `cargo install music-lounge` and that will install Music Lounge for you.


### Manually

After installing Rust run the following commands:

`git clone https://gitlab.com/NoahJelen/music-lounge`

`cd music-lounge`

`./build.sh `  <-- This will request root access in order to install the program

To remove: run `./remove.sh` or if install was done via cargo: `cargo uninstall music-lounge`

To do:
- [x] Ogg Vorbis support
- [ ] Ogg Opus support
- [ ] MP3 support
- [ ] AAC support
- [ ] FLAC support
- [ ] GUI Support
- [ ] mpris support
- [ ] Playlist Support
- [ ] Configurable theme
- [ ] Dynamic theme based on current song's artwork
- [ ] Allow user to seek the current track
- [ ] Waveform view
- [ ] Use cpal for playing audio instead of alto (I believe it is deprecated)