use {
	crate::{data::Value, result::Result},
	serde::{Deserialize, Serialize},
	std::fmt::Debug,
	thiserror::Error,
};

#[derive(Error, Serialize, Debug, PartialEq)]
pub enum RowError {
	#[error("conflict! row cannot be empty")]
	ConflictOnEmptyRow,
}

#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Row(pub Vec<Value>);

impl Row {
	pub fn get_value(&self, index: usize) -> Option<&Value> {
		self.0.get(index)
	}

	pub fn take_first_value(self) -> Result<Value> {
		self.0
			.into_iter()
			.next()
			.ok_or_else(|| RowError::ConflictOnEmptyRow.into())
	}
}
