use std::pin::Pin;
use std::task::{Poll, Context};
use futures::ready;

use tokio::io::AsyncWrite;

use connection_utils::Channel;
use super::RpcChannel;

impl AsyncWrite for RpcChannel {
    fn poll_write(
        mut self: Pin<&mut Self>,
        cx: &mut Context<'_>,
        buf: &[u8],
    ) -> Poll<Result<usize, std::io::Error>> {
        if self.write_async_future.is_none() {
            let fut = self.rpc_client.as_ref().send_channel_data(self.id(), buf.to_vec());
            self.write_async_future = Some(Box::pin(fut));
        }

        return self.poll_async_write_future(cx);
    }

    fn poll_flush(self: std::pin::Pin<&mut Self>, cx: &mut Context<'_>) -> Poll<Result<(), std::io::Error>> {
        if self.write_async_future.is_some() {
            ready!(self.poll_async_write_future(cx))?;
        }

        return Poll::Ready(Ok(()));
    }

    fn poll_shutdown(self: std::pin::Pin<&mut Self>, cx: &mut Context<'_>) -> Poll<Result<(), std::io::Error>> {
        if self.write_async_future.is_some() {
            ready!(self.poll_async_write_future(cx))?;
        }

        return Poll::Ready(Ok(()));
    }
}
