use std::task::{Poll, Context};
use tokio::io::AsyncRead;

use super::RpcChannel;

impl AsyncRead for RpcChannel {
    fn poll_read(
        mut self: std::pin::Pin<&mut Self>,
        cx: &mut Context<'_>,
        buf: &mut tokio::io::ReadBuf<'_>,
    ) -> Poll<std::io::Result<()>> {
        return AsyncRead::poll_read(self.data_source.as_mut(), cx, buf);
    }
}
