use crate::input::TextInput;

type MessageId = String;

pub enum ChatFocus {
    Message(Option<MessageId>),
    Input,
}

pub enum Focus {
    Chat(ChatFocus),
    Sidebar,
}

pub enum Mode {
    Normal,
    Insert,
    Command,
    Search,
}

pub struct User {
    pub name: String,
}

pub struct Message {
    pub content: String,
    pub from: User,
}

pub struct DirectChat {
    pub messages: Vec<Message>,
    pub input: TextInput,
    pub member: User,
}

pub struct GroupChat {
    pub messages: Vec<Message>,
    pub input: TextInput,
    pub members: Vec<User>,
    pub group_name: String,
}

pub enum Chat {
    Group(GroupChat),
    Direct(DirectChat),
}

impl Chat {
    pub fn input_mut(&mut self) -> &mut TextInput {
        match self {
            Self::Direct(DirectChat{ input, .. }) => input,
            Self::Group(GroupChat{ input, .. }) => input,
        }
    }

    pub fn input(&self) -> &TextInput {
        match self {
            Self::Direct(DirectChat{ input, .. }) => input,
            Self::Group(GroupChat{ input, .. }) => input,
        }
    }
}
