pub struct TextInput {
    content: String,
    cursor: usize,
}

impl TextInput {
    pub fn new() -> Self {
        Self {
            content: String::from(""),
            cursor: 0,
        }
    }
}

impl TextInput {
    pub fn clear(&mut self) {
        self.content = String::from("");
        self.cursor = 0;
    }

    pub fn add_char(&mut self, char: &char) {
        self.content.push(*char);
        self.cursor += 1;
    }

    pub fn get_content(&self) -> &str {
        &self.content
    }

    pub fn cursor(&self) -> u16 {
        self.cursor.try_into().unwrap()
    }

    pub fn delete_char(&mut self) {
        if self.cursor != 0 {
            let s = &self.content;
            self.content = [&s[0..self.cursor - 1], &s[self.cursor..]].concat();
            self.cursor -= 1;
        }
    }

    pub fn move_left_char(&mut self) {
        if !self.content.is_empty() {
            self.cursor -= 1;
        }
    }

    pub fn move_right_char(&mut self) {
        if self.cursor != self.content.len() {
            self.cursor += 1;
        }
    }
}
