{
  inputs = {
    nixpkgs.url = "github:NixOS/nixpkgs/nixos-unstable";

    flake-utils.url = "github:numtide/flake-utils";

    fenix = {
      url = "github:nix-community/fenix";
      inputs.nixpkgs.follows = "nixpkgs";
    };
  };

  outputs = inputs@{ self, nixpkgs, flake-utils, ... }:
    flake-utils.lib.eachDefaultSystem (system:
      let
        pkgs =
          import nixpkgs {
            inherit system;

            allowUnfree = false;
            overlays = [
              (import ./overlay.nix)
              inputs.fenix.overlay
            ];
          };
      in
      {
        packages = {
          hello = pkgs.hello;
        };

        devShell = pkgs.mkShell {
          nativeBuildInputs = with pkgs; [
            # misc
            go-task
            openssl
            pkg-config

            # rust
            (fenix.complete.withComponents [
              "cargo"
              "clippy"
              "rust-src"
              "rustc"
              "rustfmt"
            ])
            rust-analyzer-nightly
          ];
        };
      }
    );
}

