use crate::app;
use crate::icon;
use crate::id;
use crate::result;
use crate::title;

#[derive(Debug, Clone, PartialEq, Eq, PartialOrd, Ord)]
pub struct Window {
    app: *mut app::App,
    id: id::Id,
    icon: icon::Icon,
    title: title::Title,
}

impl Window {
    pub fn new(
        app: &mut app::App,
        icon: &icon::Icon,
        title: &title::Title,
    ) -> result::Result<Self> {
        Ok(Self {
            app,
            id: match id::Id::try_unique(&mut app.id_pool) {
                Ok(ok) => ok,
                Err(err) => return err.with_title("failed to generate ID").to_err(),
            },
            icon: icon.clone(),
            title: title.clone(),
        })
    }
}
