#[derive(Debug, Clone, PartialEq, Eq, PartialOrd, Ord)]
pub struct Image {
    header: Vec<u8>,
    header_size: usize,
    data: Vec<u8>,
    width: usize,
    height: usize,
}

impl Image {
    pub fn new(width: usize, height: usize) -> Self {
        let header = vec![0x90, 0x4D, 0x50, 0x49, 0x0D, 0x0A, 0x46, 0x1A];
        let header_size = header.len();
        let mut data = Vec::new();

        for _ in 0..height {
            for _ in 0..width {
                data.push(0);
            }

            data.push(0x0A);
        }

        Image {
            header,
            header_size,
            data,
            width,
            height,
        }
    }

    pub fn get(&self, index: usize) -> Option<&u8> {
        self.data.get(index)
    }

    pub fn get_mut(&mut self, index: usize) -> Option<&mut u8> {
        self.data.get_mut(index)
    }

    pub fn size(&self) -> usize {
        self.header.len() + self.len()
    }

    pub fn len(&self) -> usize {
        self.data.len()
    }
}
