use crate::result;
use rand::Rng;
use std::fmt;

#[derive(Debug, Clone, PartialEq, Eq, PartialOrd, Ord)]
pub struct Id {
    inner: Vec<u128>,
}

impl Id {
    pub fn new() -> Self {
        Self {
            inner: {
                let mut inner = Vec::new();
                let mut rng = rand::thread_rng();

                for _ in 0..4 {
                    inner.push(rng.gen_range(1000..9999));
                }

                inner
            },
        }
    }

    pub fn try_unique(pool: &mut Vec<Id>) -> result::Result<Self> {
        let mut id = Id::new();
        let mut tried = Vec::new();

        while !id.is_unique(pool) {
            id = Id::new();
            tried.push(id.clone());

            if tried.len() > pool.len() {
                return result::Error::as_err("pool is full");
            }
        }

        pool.push(id.clone());

        Ok(id)
    }

    pub fn is_unique(&self, pool: &Vec<Id>) -> bool {
        for id in pool {
            if id.inner == self.inner {
                return false;
            }
        }

        true
    }
}

impl fmt::Display for Id {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        write!(
            f,
            "{}-{}-{}-{}",
            self.inner[0], self.inner[1], self.inner[2], self.inner[3]
        )
    }
}
