use crate::id;
use crate::ui::window;

#[derive(Debug, Clone, PartialEq, Eq, PartialOrd, Ord)]
pub struct App {
    pub(crate) id_pool: Vec<id::Id>,
    windows: Vec<*mut window::Window>,
}

impl App {
    pub fn new() -> Self {
        App {
            id_pool: Vec::new(),
            windows: Vec::new(),
        }
    }

    pub fn add_window(&mut self, window: &mut window::Window) {
        self.windows.push(window);
    }
}
