use super::int;
use super::log;
use super::result;

#[test]
fn test_log() {
    use chrono::Timelike;
    use colored::Colorize;

    let now = chrono::offset::Local::now();

    assert_eq!(
        log::formatl("test-title", "test message"),
        format!(
            "[{}:{}:{}] [test-title] test message",
            now.hour(),
            now.minute(),
            now.second()
        )
    );

    assert_eq!(
        log::eformatl("test-title", "test message"),
        format!(
            "[{}:{}:{}] {} [test-title] test message",
            now.hour(),
            now.minute(),
            now.second(),
            "error".red().bold()
        )
    );
}

#[test]
fn test_result() {
    let error = result::Error::new("test error");

    assert_eq!(error.to_string(), "test error");

    match error.to_err::<u8>() {
        Ok(ok) => panic!("expected Err but got {}", ok),
        Err(err) => assert_eq!(err, error),
    };
}

#[test]
fn test_bytemerge() {
    assert_eq!(
        int::deserialize(&[0xFF, 0xFF, 0xFF, 0xFF]).unwrap(),
        0xFFFFFFFF
    );

    assert_eq!(int::deserialize(&[0xFF, 0xFF]).unwrap(), 0xFFFF);
}
