use super::result;

pub fn deserialize(bytes: &[u8]) -> result::Result<u128> {
    let mut res = 0;

    if bytes.len() == 0 {
        Ok(res)
    } else if bytes.len() > 16 {
        result::Error::quick(format!(
            "expected bytes.len() ({}) to be under 17 or equals to 16",
            bytes.len()
        ))
    } else {
        for i in 0..bytes.len() {
            res = res | (bytes[i] as u128) << ((i * 8) as u128);
        }

        Ok(res)
    }
}
