use chrono::Timelike;
use colored::Colorize;

pub fn formatl(title: &str, message: &str) -> String {
    let now = chrono::offset::Local::now();

    format!(
        "[{}:{}:{}] [{}] {}",
        now.hour(),
        now.minute(),
        now.second(),
        title,
        message
    )
}

pub fn eformatl(title: &str, message: &str) -> String {
    let now = chrono::offset::Local::now();

    format!(
        "[{}:{}:{}] {} [{}] {}",
        now.hour(),
        now.minute(),
        now.second(),
        "error".red().bold(),
        title,
        message
    )
}

#[macro_export]
macro_rules! printl {
    ($title: expr, $message: expr) => {
        println!("{}", $crate::log::formatl($title, $message))
    };
}

#[macro_export]
macro_rules! eprintl {
    ($title: expr, $message: expr) => {
        eprintln!("{}", $crate::log::eformatl($title, $message))
    };
}
