#[derive(Debug, Clone, PartialEq, Eq, PartialOrd, Ord)]
pub enum FmtLevel {
    Plain,
    Error,
}

pub fn format(level: &FmtLevel, title: &str, msg: &str) -> String {
    use colored::Colorize;

    match level {
        &FmtLevel::Plain => format!("{}: {}", title, msg.bold()),
        &FmtLevel::Error => format!("{}: {}: {}", title, "error".red().bold(), msg.bold()),
    }
}
