use super::*;

#[derive(Debug, Clone, PartialEq, Eq, PartialOrd, Ord)]
pub enum FmtLevel {
    Plain,
    Error,
}

pub fn format(level: &FmtLevel, title: &Title, msg: &str) -> String {
    use colored::Colorize;

    match level {
        &FmtLevel::Plain => format!("{}: {}", title, msg.bold()),
        &FmtLevel::Error => format!(
            "{}: {}: {}",
            title.to_string().bold(),
            "error".red().bold(),
            msg.bold()
        ),
    }
}
