use std::fmt;

#[derive(Debug, Clone, PartialEq, Eq, PartialOrd, Ord)]
pub struct Error {
    msg: String,
}

impl Error {
    pub fn new<S: AsRef<str>>(msg: S) -> Self {
        Error {
            msg: msg.as_ref().to_string(),
        }
    }

    pub fn from(err: &Error) -> Self {
        Error {
            msg: err.to_string(),
        }
    }
}

impl fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        write!(f, "{}", self.msg)
    }
}
