use super::*;

#[derive(Debug, Clone, PartialEq, Eq, PartialOrd, Ord)]
pub struct Title {
    app: *mut App,
    inner: String
}

impl Title {
    pub fn new<S: AsRef<str>>(app: &mut App, inner: S) -> Self {
        Title {
            app,
            inner: inner.as_ref().to_string()
        }
    }

    pub fn set<S: AsRef<str>>(&mut self, inner: S) {
        self.inner = inner.as_ref().to_string();
    }
}

impl ToString for Title {
    fn to_string(&self) -> String {
        self.inner.clone()
    }
}
