use super::*;

pub mod app;
pub mod title;

pub use app::*;
pub use title::*;

#[derive(Debug, Clone, PartialEq, Eq, PartialOrd, Ord)]
pub struct UIError {
    msg: String,
}

impl Error for UIError {
    fn new<S: AsRef<str>>(msg: S) -> Self {
        UIError {
            msg: msg.as_ref().to_string(),
        }
    }

    fn from<E: Error>(err: &E) -> Self {
        UIError {
            msg: err.to_string(),
        }
    }

    fn to_string(&self) -> String {
        self.msg.clone()
    }
}
