use super::*;

pub mod title;
pub mod app;

pub use title::*;
pub use app::*;

#[derive(Debug, Clone, PartialEq, Eq, PartialOrd, Ord)]
pub struct UIError {
    msg: String
}

impl Error for UIError {
    fn new<S: AsRef<str>>(msg: S) -> Self {
        UIError { msg: msg.as_ref().to_string() }
    }

    fn to_string(&self) -> String {
        self.msg.clone()
    }
}
