#[derive(Debug, Clone, PartialEq, Eq, PartialOrd, Ord)]
pub struct ErrorBox<E: Error> {
    inner: E
}

impl<E: Error> ErrorBox<E> {
    pub fn new<S: AsRef<str>>(msg: S) -> Self {
        ErrorBox { inner: E::new(msg) }
    }
}

impl<E: Error> ToString for ErrorBox<E> {
    fn to_string(&self) -> String {
        self.inner.to_string()
    }
}

impl<E: Error> From<&E> for ErrorBox<E> {
    fn from(err: &E) -> Self {
        ErrorBox { inner: E::new(err.to_string()) }
    }
}

pub trait Error {
    fn new<S: AsRef<str>>(msg: S) -> Self;
    fn to_string(&self) -> String;
}
