#[derive(Debug, PartialEq, Eq, PartialOrd, Ord)]
pub struct BasicError {
    msg: Option<String>
}

impl BasicError {
    pub fn new() -> BasicError {
        BasicError {
            msg: None
        }
    }

    pub fn from<S: AsRef<str>>(msg: S) -> BasicError {
        BasicError {
            msg: Some(msg.as_ref().to_string())
        }
    }
}

impl Clone for BasicError {
    fn clone(&self) -> BasicError {
        BasicError {
            msg: self.msg.clone()
        }
    }
}

impl ToString for BasicError {
    fn to_string(&self) -> String {
        match &self.msg {
            Some(some) => some.clone(),
            None => "error".to_string()
        }
    }
}

// Any error
pub type Error = BasicError;

// Basic errors
pub type IOError = Error;
pub type ValueError = Error;
pub type OSError = Error;

// Input/Output errors
pub type EOFError = IOError;
pub type FileError = IOError;
pub type InputError = IOError;
pub type OutputError = IOError;

// Value errors
pub type IndexError = ValueError;
pub type LengthError = ValueError;
