use super::*;

pub use msgbox::IconType;

pub fn create<S: AsRef<str>>(title: S, content: S, icon_type: IconType) -> Result<(), UIError> {
    match msgbox::create(title.as_ref(), content.as_ref(), icon_type) {
        Ok(ok) => Ok(ok),
        Err(err) => Err(UIError::from(err.to_string()))
    }
}
