pub mod err;
pub mod cli;
pub mod ui;

pub use err::*;
pub use cli::*;
pub use ui::*;

#[cfg(test)]
mod tests {
    use super::*;

    #[test]
    fn test_err() {
        let use_new = BasicError::new();

        assert_eq!(use_new.clone(), BasicError::new());
        assert_eq!(use_new.to_string(), "error".to_string());
        
        let use_str = BasicError::from("using &str");

        assert_eq!(use_str.clone(), BasicError::from("using &str"));
        assert_eq!(use_str.to_string(), "using &str".to_string());

        let use_string = BasicError::from("using String".to_string());

        assert_eq!(use_string.clone(), BasicError::from("using String"));
        assert_eq!(use_string.to_string(), "using String".to_string());
    }

    #[test]
    fn test_cli() {
        let mut cli = CLI::new("test_cli");

        cli.println("message");
        cli.eprintln("message");

        assert_eq!(cli.clone_history(), vec!["message".to_string(), "message".to_string()]);
    }

    #[test]
    fn test_msg() {
        match msg::create("Title", "Message content", msg::IconType::None) {
            Ok(_ok) => assert!(true),
            Err(err) => panic!("{}", err.to_string())
        };

        match msg::create("Title", "Message content", msg::IconType::Info) {
            Ok(_ok) => assert!(true),
            Err(err) => panic!("{}", err.to_string())
        };

        match msg::create("Title", "Message content", msg::IconType::Error) {
            Ok(_ok) => assert!(true),
            Err(err) => panic!("{}", err.to_string())
        };
    }
}
