pub mod cli;
pub mod err;

pub use cli::*;
pub use err::*;

#[cfg(test)]
mod tests {
    use super::*;

    #[test]
    fn test_err() {
        let error = BasicError::with_string("an error occured".to_string());

        assert_eq!(error.to_string(), "an error occured".to_string());
    }

    #[test]
    fn test_cli() {
        assert_eq!(basic_format(FormatLevel::Message, "a".to_string(), "b".to_string()), format!("\x1b[0;0ma: \x1b[1;0mb\x1b[0;0m"));
        assert_eq!(basic_format(FormatLevel::Error, "a".to_string(), "b".to_string()), format!("\x1b[0;0ma: \x1b[31;1merror: \x1b[1;0mb\x1b[0;0m"));
        assert_eq!(basic_format(FormatLevel::Warning, "a".to_string(), "b".to_string()), format!("\x1b[0;0ma: \x1b[33;1mwarning: \x1b[1;0mb\x1b[0;0m"));
    }
}
