use super::*;

#[derive(Clone)]
pub struct BasicError {
    msg: Option<String>
}

impl BasicError {
    pub fn new() -> BasicError {
        BasicError {
            msg: None
        }
    }

    pub fn from(msg: &str) -> BasicError {
        BasicError::with_str(msg)
    }

    pub fn with_str(msg: &str) -> BasicError {
        BasicError { msg: Some(msg.to_string()) }
    }

    pub fn with_string(msg: String) -> BasicError {
        BasicError { msg: Some(msg) }
    }

    pub fn to_string(&self) -> String {
        match self.msg.clone() {
            Some(some) => some,
            None => "unknown error".to_string()
        }
    }
}

pub type Error = BasicError;
pub type ValueError = BasicError;
pub type IOError = BasicError;

pub fn exit(title: String, error: BasicError) -> ! {
    eprintln_exit(title, error.to_string())
}
