pub const EXIT_ERROR: i32 = 1;

pub enum FormatLevel {
    Message,
    Error,
    Warning
}

pub fn basic_format(fmt_level: FormatLevel, title: String, msg: String) -> String {
    match fmt_level {
        FormatLevel::Message => format!("\x1b[0;0m{}: \x1b[1;0m{}\x1b[0;0m", title, msg),
        FormatLevel::Error => format!("\x1b[0;0m{}: \x1b[31;1merror: \x1b[1;0m{}\x1b[0;0m", title, msg),
        FormatLevel::Warning => format!("\x1b[0;0m{}: \x1b[33;1mwarning: \x1b[1;0m{}\x1b[0;0m", title, msg)
    }
}

pub fn basic_println(fmt_level: FormatLevel, title: String, msg: String) {
    println!("{}", basic_format(fmt_level, title, msg))
}

pub fn format(title: String, msg: String) -> String {
    basic_format(FormatLevel::Message, title, msg)
}

pub fn eformat(title: String, msg: String) -> String {
    basic_format(FormatLevel::Error, title, msg)
}

pub fn wformat(title: String, msg: String) -> String {
    basic_format(FormatLevel::Warning, title, msg)
}

pub fn println(title: String, msg: String) {
    basic_println(FormatLevel::Message, title, msg)
}

pub fn eprintln(title: String, msg: String) {
    basic_println(FormatLevel::Error, title, msg)
}

pub fn wprintln(title: String, msg: String) {
    basic_println(FormatLevel::Warning, title, msg)
}

pub fn eprintln_exit(title: String, msg: String) -> ! {
    eprintln(title, msg);

    std::process::exit(EXIT_ERROR);
}

pub fn clear() {
    print!("\x1B[2J\x1B[1;1H")
}
