# Changelog

# 0.9.0
- Remove `old_path` and `PatchPath` and use only `TreePath` which describes the path traversal for the target DOM element
- Remove `AttValue`, so we can only deal with `VAL` which is the `AttributeValue` from sauron, which contains simple values and Callbacks

## 0.8.0
- refactor `diff` and `diff::keyed_elements` splitting it into small functions.
    - minimize the use of mutable collections
    - rename variables to appropriate names
    - Fix AppendChildren patch to also add to already_inserted when creating the patch
    - Use consistent naming of variables as in diff for keyed_elements
- Change tag line to `mt-dom`
- **breaking** Refactor `Patch` to make use of `PatchPath` and `TreePath` as an alternative method to using `NodeIdx` to traverse the DOM.
- Add `Zipper` implementation to traverse the `Node`.

## 0.7.1
- Remove warnings

## 0.7.0
 - **breaking** Move Callback to sauron and mt-dom will focus solely on vdom diffing.
 - modify the diffing algorithmn to replace a node when the key didn't matched

## 0.6.0
- Add a REP for explicitly replace the node when REP evaluates to true
- Patch variant now contains NodeIdx for the new node inserted, appended, and the replacement node
- Convert Text variant into a struct
- Add skip function as an optimization feature for diffing old and new node

## 0.5.3
- Fix ReplaceNode tag to be optional, for replacing text node

## 0.5.2
- Fix bug on attributes not diffed in keyed_elements

## 0.5.1
- Fix bug on AppendChildren node_idx

## 0.5.0
- Overhaul the algorithmn for the diffing keyed elements.
- Change InsertChildren into InsertNode
- Change RemoveChildren into RemoveNode
- Add apply_patches for mt-dom for verifying the patch produces the target vdom
- Add Debug contraint for NS,ATT and VAL for easier debugging
- Add a self closing flag in Element
- Improve the diffing algorithm for keyed elements to accomodate included elements that are not keyed
- Add with-measure feature to see what's happenning inside the code

## 0.4.1
- Add utility `node_count` function to count the number of nodes from the node tree
- Add a function `add_children_ref_mut` to `Node` for node to add a children using a mutable reference to self
- Add `map_msg` function for `Attribute`

## 0.4.0
- Fix get_attribute_value to return all the values of the attributes which matched the name, as opposed to only returning the first match
- Add test case for multiple calls to the same attribute should be included in the patch even if only 1 changed in the same attribute name
- Add a children_mut method to return a mutable reference to the children of the node
- Group the attributes by name before comparing

## 0.3.0
- Add note limitation on Callback
- Use a reconciliation algorithm to try match keyed elements
- TruncateChildren in Patches since it is replaced with RemoveChildren
- Implement a manual debug for Node, and Element

## 0.2.2
- Add utility function to merge to existing attributes of the same name
- Add a function merge_attributes to specifically find for existing attributes of an element and merge it

## 0.2.1
- revise the implementation of diff, not needing the merge attributes of the same name, since it adds a performance penalty
- constructing the nodes should use the utility to make multiple values of attributes aggregated right from building of the virtual dom

