use mt_dom::{diff::*, patch::*, *};

pub type MyNode =
    Node<&'static str, &'static str, &'static str, &'static str, &'static str>;

#[test]
fn key_inserted_at_start() {
    let old: MyNode = element(
        "main",
        vec![attr("class", "container")],
        vec![
            element("div", vec![attr("key", "1")], vec![leaf("line1")]),
            element("div", vec![attr("key", "2")], vec![leaf("line2")]),
            element("div", vec![attr("key", "3")], vec![leaf("line3")]),
            element("div", vec![attr("key", "4")], vec![leaf("line4")]),
            element("div", vec![attr("key", "5")], vec![leaf("line5")]),
            element("div", vec![attr("key", "6")], vec![leaf("line6")]),
            element("div", vec![attr("key", "7")], vec![leaf("line7")]),
            element("div", vec![attr("key", "8")], vec![leaf("line8")]),
            element("div", vec![attr("key", "9")], vec![leaf("line9")]),
        ],
    );

    let new: MyNode = element(
        "main",
        vec![attr("class", "container")],
        vec![
            element("div", vec![attr("key", "XXX")], vec![leaf("lineXXX")]),
            element("div", vec![attr("key", "1")], vec![leaf("line1")]),
            element("div", vec![attr("key", "2")], vec![leaf("line2")]),
            element("div", vec![attr("key", "3")], vec![leaf("line3")]),
            element("div", vec![attr("key", "4")], vec![leaf("line4")]),
            element("div", vec![attr("key", "5")], vec![leaf("line5")]),
            element("div", vec![attr("key", "6")], vec![leaf("line6")]),
            element("div", vec![attr("key", "7")], vec![leaf("line7")]),
            element("div", vec![attr("key", "8")], vec![leaf("line8")]),
            element("div", vec![attr("key", "9")], vec![leaf("line9")]),
        ],
    );

    let diff = diff_with_key(&old, &new, &"key");
    assert_eq!(
        diff,
        vec![Patch::insert_node(
            Some(&"main"),
            TreePath::new(vec![0, 0]),
            &element("div", vec![attr("key", "XXX")], vec![leaf("lineXXX")])
        )]
    );
}

#[test]
fn key_inserted_at_middle() {
    pretty_env_logger::try_init().ok();
    let old: MyNode = element(
        "main",
        vec![attr("class", "container")],
        vec![
            element("div", vec![attr("key", "1")], vec![leaf("line1")]),
            element("div", vec![attr("key", "2")], vec![leaf("line2")]),
            element("div", vec![attr("key", "3")], vec![leaf("line3")]),
            element("div", vec![attr("key", "4")], vec![leaf("line4")]),
            element("div", vec![attr("key", "5")], vec![leaf("line5")]),
            element("div", vec![attr("key", "6")], vec![leaf("line6")]),
            element("div", vec![attr("key", "7")], vec![leaf("line7")]),
            element("div", vec![attr("key", "8")], vec![leaf("line8")]),
            element("div", vec![attr("key", "9")], vec![leaf("line9")]),
        ],
    );

    let new: MyNode = element(
        "main",
        vec![attr("class", "container")],
        vec![
            element("div", vec![attr("key", "1")], vec![leaf("line1")]),
            element("div", vec![attr("key", "2")], vec![leaf("line2")]),
            element("div", vec![attr("key", "3")], vec![leaf("line3")]),
            element("div", vec![attr("key", "4")], vec![leaf("line4")]),
            element("div", vec![attr("key", "5")], vec![leaf("line5")]),
            element("div", vec![attr("key", "XXX")], vec![leaf("lineXXX")]),
            element("div", vec![attr("key", "6")], vec![leaf("line6")]),
            element("div", vec![attr("key", "7")], vec![leaf("line7")]),
            element("div", vec![attr("key", "8")], vec![leaf("line8")]),
            element("div", vec![attr("key", "9")], vec![leaf("line9")]),
        ],
    );

    let diff = diff_with_key(&old, &new, &"key");
    dbg!(&diff);

    assert_eq!(
        diff,
        vec![Patch::insert_node(
            Some(&"main"),
            TreePath::new(vec![0, 5]),
            &element("div", vec![attr("key", "XXX")], vec![leaf("lineXXX")])
        )]
    );
}

#[test]
fn wrapped_elements() {
    pretty_env_logger::try_init().ok();
    let old: MyNode = element(
        "article",
        vec![],
        vec![element(
            "main",
            vec![attr("class", "container")],
            vec![
                element("div", vec![attr("key", "1")], vec![leaf("line1")]),
                element("div", vec![attr("key", "2")], vec![leaf("line2")]),
                element("div", vec![attr("key", "3")], vec![leaf("line3")]),
                element("div", vec![attr("key", "4")], vec![leaf("line4")]),
                element("div", vec![attr("key", "5")], vec![leaf("line5")]),
                element("div", vec![attr("key", "6")], vec![leaf("line6")]),
                element("div", vec![attr("key", "7")], vec![leaf("line7")]),
                element("div", vec![attr("key", "8")], vec![leaf("line8")]),
                element("div", vec![attr("key", "9")], vec![leaf("line9")]),
            ],
        )],
    );

    let new: MyNode = element(
        "article",
        vec![],
        vec![element(
            "main",
            vec![attr("class", "container")],
            vec![
                element("div", vec![attr("key", "1")], vec![leaf("line1")]),
                element("div", vec![attr("key", "2")], vec![leaf("line2")]),
                element("div", vec![attr("key", "3")], vec![leaf("line3")]),
                element("div", vec![attr("key", "4")], vec![leaf("line4")]),
                element("div", vec![attr("key", "5")], vec![leaf("line5")]),
                element("div", vec![attr("key", "XXX")], vec![leaf("lineXXX")]),
                element("div", vec![attr("key", "6")], vec![leaf("line6")]),
                element("div", vec![attr("key", "7")], vec![leaf("line7")]),
                element("div", vec![attr("key", "8")], vec![leaf("line8")]),
                element("div", vec![attr("key", "9")], vec![leaf("line9")]),
            ],
        )],
    );

    let diff = diff_with_key(&old, &new, &"key");
    dbg!(&diff);
    assert_eq!(
        diff,
        vec![Patch::insert_node(
            Some(&"main"),
            TreePath::new(vec![0, 0, 5]),
            &element("div", vec![attr("key", "XXX")], vec![leaf("lineXXX")])
        )]
    );
}

#[test]
fn text_changed() {
    pretty_env_logger::try_init().ok();
    let old: MyNode = element(
        "article",
        vec![],
        vec![element(
            "main",
            vec![attr("class", "container")],
            vec![
                element("div", vec![attr("key", "1")], vec![leaf("line1")]),
                element("div", vec![attr("key", "2")], vec![leaf("line2")]),
                element("div", vec![attr("key", "3")], vec![leaf("line3")]),
                element("div", vec![attr("key", "4")], vec![leaf("line4")]),
                element("div", vec![attr("key", "5")], vec![leaf("line5")]),
                element("div", vec![attr("key", "6")], vec![leaf("line6")]),
                element("div", vec![attr("key", "7")], vec![leaf("line7")]),
                element("div", vec![attr("key", "8")], vec![leaf("line8")]),
                element("div", vec![attr("key", "9")], vec![leaf("line9")]),
            ],
        )],
    );

    let new: MyNode = element(
        "article",
        vec![],
        vec![element(
            "main",
            vec![attr("class", "container")],
            vec![
                element("div", vec![attr("key", "1")], vec![leaf("line1")]),
                element("div", vec![attr("key", "2")], vec![leaf("line2")]),
                element("div", vec![attr("key", "3")], vec![leaf("line3")]),
                element("div", vec![attr("key", "4")], vec![leaf("line4")]),
                element("div", vec![attr("key", "5")], vec![leaf("line5")]),
                element("div", vec![attr("key", "6")], vec![leaf("line6")]),
                element(
                    "div",
                    vec![attr("key", "7")],
                    vec![leaf("line7_changed")],
                ),
                element("div", vec![attr("key", "8")], vec![leaf("line8")]),
                element("div", vec![attr("key", "9")], vec![leaf("line9")]),
            ],
        )],
    );

    let diff = diff_with_key(&old, &new, &"key");
    dbg!(&diff);
    assert_eq!(
        diff,
        vec![Patch::replace_leaf(
            TreePath::new(vec![0, 0, 6, 0]),
            &"line7",
            &"line7_changed"
        )]
    );
}

#[test]
fn text_changed_non_keyed() {
    pretty_env_logger::try_init().ok();
    let old: MyNode = element(
        "article",
        vec![],
        vec![element(
            "main",
            vec![attr("class", "container")],
            vec![
                element("div", vec![], vec![leaf("line1")]),
                element("div", vec![], vec![leaf("line2")]),
                element("div", vec![], vec![leaf("line3")]),
                element("div", vec![], vec![leaf("line4")]),
                element("div", vec![], vec![leaf("line5")]),
                element("div", vec![], vec![leaf("line6")]),
                element("div", vec![], vec![leaf("line7")]),
                element("div", vec![], vec![leaf("line8")]),
                element("div", vec![], vec![leaf("line9")]),
            ],
        )],
    );

    let new: MyNode = element(
        "article",
        vec![],
        vec![element(
            "main",
            vec![attr("class", "container")],
            vec![
                element("div", vec![], vec![leaf("line1")]),
                element("div", vec![], vec![leaf("line2")]),
                element("div", vec![], vec![leaf("line3")]),
                element("div", vec![], vec![leaf("line4")]),
                element("div", vec![], vec![leaf("line5")]),
                element("div", vec![], vec![leaf("line6")]),
                element("div", vec![], vec![leaf("line7_changed")]),
                element("div", vec![], vec![leaf("line8")]),
                element("div", vec![], vec![leaf("line9")]),
            ],
        )],
    );

    let diff = diff_with_key(&old, &new, &"key");
    dbg!(&diff);

    assert_eq!(
        diff,
        vec![Patch::replace_leaf(
            TreePath::new(vec![0, 0, 6, 0]),
            &"line7",
            &"line7_changed"
        )]
    );
}

#[test]
fn insert_one_line_at_start() {
    pretty_env_logger::try_init().ok();
    let old: MyNode = element(
        "article",
        vec![],
        vec![element(
            "main",
            vec![attr("class", "container")],
            vec![
                element(
                    "div",
                    vec![attr("key", "hash1")],
                    vec![
                        element("div", vec![], vec![leaf("1")]),
                        element("div", vec![], vec![leaf("line1")]),
                    ],
                ),
                element(
                    "div",
                    vec![attr("key", "hash2")],
                    vec![
                        element("div", vec![], vec![leaf("2")]),
                        element("div", vec![], vec![leaf("line3")]),
                    ],
                ),
                element(
                    "div",
                    vec![attr("key", "hash3")],
                    vec![
                        element("div", vec![], vec![leaf("3")]),
                        element("div", vec![], vec![leaf("line3")]),
                    ],
                ),
            ],
        )],
    );

    let new: MyNode = element(
        "article",
        vec![],
        vec![element(
            "main",
            vec![attr("class", "container")],
            vec![
                element(
                    "div",
                    vec![attr("key", "hashXXX")],
                    vec![
                        element("div", vec![], vec![leaf("1")]),
                        element("div", vec![], vec![leaf("XXX")]),
                    ],
                ),
                element(
                    "div",
                    vec![attr("key", "hash1")],
                    vec![
                        element("div", vec![], vec![leaf("2")]),
                        element("div", vec![], vec![leaf("line1")]),
                    ],
                ),
                element(
                    "div",
                    vec![attr("key", "hash2")],
                    vec![
                        element("div", vec![], vec![leaf("3")]),
                        element("div", vec![], vec![leaf("line3")]),
                    ],
                ),
                element(
                    "div",
                    vec![attr("key", "hash3")],
                    vec![
                        element("div", vec![], vec![leaf("4")]),
                        element("div", vec![], vec![leaf("line3")]),
                    ],
                ),
            ],
        )],
    );

    let diff = diff_with_key(&old, &new, &"key");
    dbg!(&diff);
    assert_eq!(
        diff,
        vec![
            Patch::replace_leaf(TreePath::new(vec![0, 0, 0, 0, 0]), &"1", &"2"),
            Patch::replace_leaf(TreePath::new(vec![0, 0, 1, 0, 0]), &"2", &"3"),
            Patch::replace_leaf(TreePath::new(vec![0, 0, 2, 0, 0]), &"3", &"4"),
            Patch::insert_node(
                Some(&"main"),
                TreePath::new(vec![0, 0, 0]),
                &element(
                    "div",
                    vec![attr("key", "hashXXX")],
                    vec![
                        element("div", vec![], vec![leaf("1")]),
                        element("div", vec![], vec![leaf("XXX")]),
                    ],
                ),
            )
        ]
    );
}

#[test]
fn insert_two_lines_at_start() {
    pretty_env_logger::try_init().ok();
    let old: MyNode = element(
        "article",
        vec![],
        vec![element(
            "main",
            vec![attr("class", "container")],
            vec![
                element(
                    "div",
                    vec![attr("key", "hash1")],
                    vec![
                        element("div", vec![], vec![leaf("1")]),
                        element("div", vec![], vec![leaf("line1")]),
                    ],
                ),
                element(
                    "div",
                    vec![attr("key", "hash2")],
                    vec![
                        element("div", vec![], vec![leaf("2")]),
                        element("div", vec![], vec![leaf("line2")]),
                    ],
                ),
                element(
                    "div",
                    vec![attr("key", "hash3")],
                    vec![
                        element("div", vec![], vec![leaf("2")]),
                        element("div", vec![], vec![leaf("line3")]),
                    ],
                ),
            ],
        )],
    );

    let new: MyNode = element(
        "article",
        vec![],
        vec![element(
            "main",
            vec![attr("class", "container")],
            vec![
                element(
                    "div",
                    vec![attr("key", "hashXXX")],
                    vec![
                        element("div", vec![], vec![leaf("1")]),
                        element("div", vec![], vec![leaf("XXX")]),
                    ],
                ),
                element(
                    "div",
                    vec![attr("key", "hashYYY")],
                    vec![
                        element("div", vec![], vec![leaf("2")]),
                        element("div", vec![], vec![leaf("YYY")]),
                    ],
                ),
                element(
                    "div",
                    vec![attr("key", "hash1")],
                    vec![
                        element("div", vec![], vec![leaf("3")]),
                        element("div", vec![], vec![leaf("line1")]),
                    ],
                ),
                element(
                    "div",
                    vec![attr("key", "hash2")],
                    vec![
                        element("div", vec![], vec![leaf("4")]),
                        element("div", vec![], vec![leaf("line2")]),
                    ],
                ),
                element(
                    "div",
                    vec![attr("key", "hash3")],
                    vec![
                        element("div", vec![], vec![leaf("5")]),
                        element("div", vec![], vec![leaf("line3")]),
                    ],
                ),
            ],
        )],
    );

    let diff = diff_with_key(&old, &new, &"key");
    dbg!(&diff);

    assert_eq!(
        diff,
        vec![
            Patch::replace_leaf(TreePath::new(vec![0, 0, 0, 0, 0]), &"1", &"3"),
            Patch::replace_leaf(TreePath::new(vec![0, 0, 1, 0, 0]), &"2", &"4"),
            Patch::replace_leaf(TreePath::new(vec![0, 0, 2, 0, 0]), &"2", &"5"),
            Patch::insert_node(
                Some(&"main"),
                TreePath::new(vec![0, 0, 0]),
                &element(
                    "div",
                    vec![attr("key", "hashXXX")],
                    vec![
                        element("div", vec![], vec![leaf("1")]),
                        element("div", vec![], vec![leaf("XXX")]),
                    ],
                ),
            ),
            Patch::insert_node(
                Some(&"main"),
                TreePath::new(vec![0, 0, 0]),
                &element(
                    "div",
                    vec![attr("key", "hashYYY")],
                    vec![
                        element("div", vec![], vec![leaf("2")]),
                        element("div", vec![], vec![leaf("YYY")]),
                    ],
                )
            ),
        ]
    );
}
