#![feature(abi_msp430_interrupt)]
#![doc = "Peripheral access API for MSP430FR6972 microcontrollers (generated using svd2rust v0.18.0 ( ))\n\nYou can find an overview of the generated API [here].\n\nAPI features to be included in the [next]
svd2rust release can be generated by cloning the svd2rust [repository], checking out the above commit, and running `cargo doc --open`.\n\n[here]: https://docs.rs/svd2rust/0.18.0/svd2rust/#peripheral-api\n[next]: https://github.com/rust-embedded/svd2rust/blob/master/CHANGELOG.md#unreleased\n[repository]: https://github.com/rust-embedded/svd2rust"]
#![deny(const_err)]
#![deny(dead_code)]
#![deny(improper_ctypes)]
#![deny(missing_docs)]
#![deny(no_mangle_generic_items)]
#![deny(non_shorthand_field_patterns)]
#![deny(overflowing_literals)]
#![deny(path_statements)]
#![deny(patterns_in_fns_without_body)]
#![deny(private_in_public)]
#![deny(unconditional_recursion)]
#![deny(unused_allocation)]
#![deny(unused_comparisons)]
#![deny(unused_parens)]
#![deny(while_true)]
#![allow(non_camel_case_types)]
#![allow(non_snake_case)]
#![no_std]
#[cfg(feature = "rt")]
pub use self::Interrupt as interrupt;
use core::marker::PhantomData;
use core::ops::Deref;
#[allow(unused_imports)]
use generic::*;
#[cfg(feature = "rt")]
pub use msp430_rt::interrupt;
#[doc = r"Common register and bit access and modify traits"]
pub mod generic;
#[cfg(feature = "rt")]
extern "msp430-interrupt" {
    fn AES256();
    fn RTC();
    fn LCD_C();
    fn PORT4();
    fn PORT3();
    fn TIMER3_A1();
    fn TIMER3_A0();
    fn PORT2();
    fn TIMER2_A1();
    fn TIMER2_A0();
    fn PORT1();
    fn TIMER1_A1();
    fn TIMER1_A0();
    fn DMA();
    fn USCI_B1();
    fn USCI_A1();
    fn TIMER0_A1();
    fn TIMER0_A0();
    fn ADC12();
    fn USCI_B0();
    fn USCI_A0();
    fn WDT();
    fn TIMER0_B1();
    fn TIMER0_B0();
    fn COMP_E();
    fn UNMI();
    fn SYSNMI();
}
#[doc(hidden)]
pub union Vector {
    _handler: unsafe extern "msp430-interrupt" fn(),
    _reserved: u16,
}
#[cfg(feature = "rt")]
#[doc(hidden)]
#[link_section = ".vector_table.interrupts"]
#[no_mangle]
#[used]
pub static __INTERRUPTS: [Vector; 55] = [
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _handler: AES256 },
    Vector { _handler: RTC },
    Vector { _handler: LCD_C },
    Vector { _handler: PORT4 },
    Vector { _handler: PORT3 },
    Vector {
        _handler: TIMER3_A1,
    },
    Vector {
        _handler: TIMER3_A0,
    },
    Vector { _handler: PORT2 },
    Vector {
        _handler: TIMER2_A1,
    },
    Vector {
        _handler: TIMER2_A0,
    },
    Vector { _handler: PORT1 },
    Vector {
        _handler: TIMER1_A1,
    },
    Vector {
        _handler: TIMER1_A0,
    },
    Vector { _handler: DMA },
    Vector { _handler: USCI_B1 },
    Vector { _handler: USCI_A1 },
    Vector {
        _handler: TIMER0_A1,
    },
    Vector {
        _handler: TIMER0_A0,
    },
    Vector { _handler: ADC12 },
    Vector { _handler: USCI_B0 },
    Vector { _handler: USCI_A0 },
    Vector { _reserved: 0 },
    Vector { _handler: WDT },
    Vector {
        _handler: TIMER0_B1,
    },
    Vector {
        _handler: TIMER0_B0,
    },
    Vector { _handler: COMP_E },
    Vector { _handler: UNMI },
    Vector { _handler: SYSNMI },
];
#[doc = r"Enumeration of all the interrupts. This enum is seldom used in application or library crates. It is present primarily for documenting the device's implemented interrupts."]
#[derive(Copy, Clone, Debug, PartialEq, Eq)]
#[repr(u16)]
pub enum Interrupt {
    #[doc = "27 - 0xFFC6 AES256"]
    AES256 = 27,
    #[doc = "28 - 0xFFC8 RTC"]
    RTC = 28,
    #[doc = "29 - 0xFFCA LCD C"]
    LCD_C = 29,
    #[doc = "30 - 0xFFCC Port 4"]
    PORT4 = 30,
    #[doc = "31 - 0xFFCE Port 3"]
    PORT3 = 31,
    #[doc = "32 - 0xFFD0 Timer3_A2 CC1, TA"]
    TIMER3_A1 = 32,
    #[doc = "33 - 0xFFD2 Timer3_A2 CC0"]
    TIMER3_A0 = 33,
    #[doc = "34 - 0xFFD4 Port 2"]
    PORT2 = 34,
    #[doc = "35 - 0xFFD6 Timer2_A3 CC1, TA"]
    TIMER2_A1 = 35,
    #[doc = "36 - 0xFFD8 Timer2_A3 CC0"]
    TIMER2_A0 = 36,
    #[doc = "37 - 0xFFDA Port 1"]
    PORT1 = 37,
    #[doc = "38 - 0xFFDC Timer1_A3 CC1-2, TA1"]
    TIMER1_A1 = 38,
    #[doc = "39 - 0xFFDE Timer1_A3 CC0"]
    TIMER1_A0 = 39,
    #[doc = "40 - 0xFFE0 DMA"]
    DMA = 40,
    #[doc = "41 - 0xFFE2 USCI B1 Receive/Transmit"]
    USCI_B1 = 41,
    #[doc = "42 - 0xFFE4 USCI A1 Receive/Transmit"]
    USCI_A1 = 42,
    #[doc = "43 - 0xFFE6 Timer0_A5 CC1-4, TA"]
    TIMER0_A1 = 43,
    #[doc = "44 - 0xFFE8 Timer0_A5 CC0"]
    TIMER0_A0 = 44,
    #[doc = "45 - 0xFFEA ADC"]
    ADC12 = 45,
    #[doc = "46 - 0xFFEC USCI B0 Receive/Transmit"]
    USCI_B0 = 46,
    #[doc = "47 - 0xFFEE USCI A0 Receive/Transmit"]
    USCI_A0 = 47,
    #[doc = "49 - 0xFFF2 Watchdog Timer"]
    WDT = 49,
    #[doc = "50 - 0xFFF4 Timer0_B3 CC1-2, TB"]
    TIMER0_B1 = 50,
    #[doc = "51 - 0xFFF6 Timer0_B3 CC0"]
    TIMER0_B0 = 51,
    #[doc = "52 - 0xFFF8 Comparator E"]
    COMP_E = 52,
    #[doc = "53 - 0xFFFA User Non-maskable"]
    UNMI = 53,
    #[doc = "54 - 0xFFFC System Non-maskable"]
    SYSNMI = 54,
}
#[doc = "Port 1/2"]
pub struct PORT_1_2 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PORT_1_2 {}
impl PORT_1_2 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const port_1_2::RegisterBlock = 0x0200 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const port_1_2::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PORT_1_2 {
    type Target = port_1_2::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PORT_1_2 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PORT_1_2").finish()
    }
}
#[doc = "Port 1/2"]
pub mod port_1_2;
#[doc = "Port 3/4"]
pub struct PORT_3_4 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PORT_3_4 {}
impl PORT_3_4 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const port_3_4::RegisterBlock = 0x0220 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const port_3_4::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PORT_3_4 {
    type Target = port_3_4::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PORT_3_4 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PORT_3_4").finish()
    }
}
#[doc = "Port 3/4"]
pub mod port_3_4;
#[doc = "Port 5/6"]
pub struct PORT_5_6 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PORT_5_6 {}
impl PORT_5_6 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const port_5_6::RegisterBlock = 0x0240 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const port_5_6::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PORT_5_6 {
    type Target = port_5_6::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PORT_5_6 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PORT_5_6").finish()
    }
}
#[doc = "Port 5/6"]
pub mod port_5_6;
#[doc = "Port 7"]
pub struct PORT_7 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PORT_7 {}
impl PORT_7 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const port_7::RegisterBlock = 0x0260 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const port_7::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PORT_7 {
    type Target = port_7::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PORT_7 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PORT_7").finish()
    }
}
#[doc = "Port 7"]
pub mod port_7;
#[doc = "Port 9"]
pub struct PORT_9 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PORT_9 {}
impl PORT_9 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const port_9::RegisterBlock = 0x0280 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const port_9::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PORT_9 {
    type Target = port_9::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PORT_9 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PORT_9").finish()
    }
}
#[doc = "Port 9"]
pub mod port_9;
#[doc = "RTC_C Real Time Clock"]
pub struct RTC_C_REAL_TIME_CLOCK {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for RTC_C_REAL_TIME_CLOCK {}
impl RTC_C_REAL_TIME_CLOCK {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const rtc_c_real_time_clock::RegisterBlock = 0x04a0 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const rtc_c_real_time_clock::RegisterBlock {
        Self::PTR
    }
}
impl Deref for RTC_C_REAL_TIME_CLOCK {
    type Target = rtc_c_real_time_clock::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for RTC_C_REAL_TIME_CLOCK {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("RTC_C_REAL_TIME_CLOCK").finish()
    }
}
#[doc = "RTC_C Real Time Clock"]
pub mod rtc_c_real_time_clock;
#[doc = "USCI_A0 UART Mode"]
pub struct USCI_A0_UART_MODE {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for USCI_A0_UART_MODE {}
impl USCI_A0_UART_MODE {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const usci_a0_uart_mode::RegisterBlock = 0x05c0 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const usci_a0_uart_mode::RegisterBlock {
        Self::PTR
    }
}
impl Deref for USCI_A0_UART_MODE {
    type Target = usci_a0_uart_mode::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for USCI_A0_UART_MODE {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("USCI_A0_UART_MODE").finish()
    }
}
#[doc = "USCI_A0 UART Mode"]
pub mod usci_a0_uart_mode;
#[doc = "USCI_A0 SPI Mode"]
pub struct USCI_A0_SPI_MODE {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for USCI_A0_SPI_MODE {}
impl USCI_A0_SPI_MODE {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const usci_a0_spi_mode::RegisterBlock = 0x05c0 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const usci_a0_spi_mode::RegisterBlock {
        Self::PTR
    }
}
impl Deref for USCI_A0_SPI_MODE {
    type Target = usci_a0_spi_mode::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for USCI_A0_SPI_MODE {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("USCI_A0_SPI_MODE").finish()
    }
}
#[doc = "USCI_A0 SPI Mode"]
pub mod usci_a0_spi_mode;
#[doc = "USCI_A1 UART Mode"]
pub struct USCI_A1_UART_MODE {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for USCI_A1_UART_MODE {}
impl USCI_A1_UART_MODE {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const usci_a1_uart_mode::RegisterBlock = 0x05e0 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const usci_a1_uart_mode::RegisterBlock {
        Self::PTR
    }
}
impl Deref for USCI_A1_UART_MODE {
    type Target = usci_a1_uart_mode::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for USCI_A1_UART_MODE {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("USCI_A1_UART_MODE").finish()
    }
}
#[doc = "USCI_A1 UART Mode"]
pub mod usci_a1_uart_mode;
#[doc = "USCI_A1 SPI Mode"]
pub struct USCI_A1_SPI_MODE {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for USCI_A1_SPI_MODE {}
impl USCI_A1_SPI_MODE {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const usci_a1_spi_mode::RegisterBlock = 0x05e0 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const usci_a1_spi_mode::RegisterBlock {
        Self::PTR
    }
}
impl Deref for USCI_A1_SPI_MODE {
    type Target = usci_a1_spi_mode::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for USCI_A1_SPI_MODE {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("USCI_A1_SPI_MODE").finish()
    }
}
#[doc = "USCI_A1 SPI Mode"]
pub mod usci_a1_spi_mode;
#[doc = "USCI_B0 I2C Mode"]
pub struct USCI_B0_I2C_MODE {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for USCI_B0_I2C_MODE {}
impl USCI_B0_I2C_MODE {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const usci_b0_i2c_mode::RegisterBlock = 0x0640 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const usci_b0_i2c_mode::RegisterBlock {
        Self::PTR
    }
}
impl Deref for USCI_B0_I2C_MODE {
    type Target = usci_b0_i2c_mode::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for USCI_B0_I2C_MODE {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("USCI_B0_I2C_MODE").finish()
    }
}
#[doc = "USCI_B0 I2C Mode"]
pub mod usci_b0_i2c_mode;
#[doc = "USCI_B0 SPI Mode"]
pub struct USCI_B0_SPI_MODE {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for USCI_B0_SPI_MODE {}
impl USCI_B0_SPI_MODE {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const usci_b0_spi_mode::RegisterBlock = 0x0640 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const usci_b0_spi_mode::RegisterBlock {
        Self::PTR
    }
}
impl Deref for USCI_B0_SPI_MODE {
    type Target = usci_b0_spi_mode::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for USCI_B0_SPI_MODE {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("USCI_B0_SPI_MODE").finish()
    }
}
#[doc = "USCI_B0 SPI Mode"]
pub mod usci_b0_spi_mode;
#[doc = "USCI_B1 I2C Mode"]
pub struct USCI_B1_I2C_MODE {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for USCI_B1_I2C_MODE {}
impl USCI_B1_I2C_MODE {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const usci_b1_i2c_mode::RegisterBlock = 0x0680 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const usci_b1_i2c_mode::RegisterBlock {
        Self::PTR
    }
}
impl Deref for USCI_B1_I2C_MODE {
    type Target = usci_b1_i2c_mode::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for USCI_B1_I2C_MODE {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("USCI_B1_I2C_MODE").finish()
    }
}
#[doc = "USCI_B1 I2C Mode"]
pub mod usci_b1_i2c_mode;
#[doc = "USCI_B1 SPI Mode"]
pub struct USCI_B1_SPI_MODE {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for USCI_B1_SPI_MODE {}
impl USCI_B1_SPI_MODE {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const usci_b1_spi_mode::RegisterBlock = 0x0680 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const usci_b1_spi_mode::RegisterBlock {
        Self::PTR
    }
}
impl Deref for USCI_B1_SPI_MODE {
    type Target = usci_b1_spi_mode::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for USCI_B1_SPI_MODE {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("USCI_B1_SPI_MODE").finish()
    }
}
#[doc = "USCI_B1 SPI Mode"]
pub mod usci_b1_spi_mode;
#[doc = "LCD_C"]
pub struct LCD_C {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for LCD_C {}
impl LCD_C {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const lcd_c::RegisterBlock = 0x0a00 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const lcd_c::RegisterBlock {
        Self::PTR
    }
}
impl Deref for LCD_C {
    type Target = lcd_c::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for LCD_C {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("LCD_C").finish()
    }
}
#[doc = "LCD_C"]
pub mod lcd_c;
#[doc = "SFR Special Function Registers"]
pub struct SFR {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SFR {}
impl SFR {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const sfr::RegisterBlock = 0x0100 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const sfr::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SFR {
    type Target = sfr::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SFR {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SFR").finish()
    }
}
#[doc = "SFR Special Function Registers"]
pub mod sfr;
#[doc = "PMM Power Management System"]
pub struct PMM {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PMM {}
impl PMM {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pmm::RegisterBlock = 0x0120 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pmm::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PMM {
    type Target = pmm::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PMM {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PMM").finish()
    }
}
#[doc = "PMM Power Management System"]
pub mod pmm;
#[doc = "FRAM"]
pub struct FRAM {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for FRAM {}
impl FRAM {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const fram::RegisterBlock = 0x0140 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const fram::RegisterBlock {
        Self::PTR
    }
}
impl Deref for FRAM {
    type Target = fram::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for FRAM {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("FRAM").finish()
    }
}
#[doc = "FRAM"]
pub mod fram;
#[doc = "CRC16"]
pub struct CRC16 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CRC16 {}
impl CRC16 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const crc16::RegisterBlock = 0x0150 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const crc16::RegisterBlock {
        Self::PTR
    }
}
impl Deref for CRC16 {
    type Target = crc16::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for CRC16 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("CRC16").finish()
    }
}
#[doc = "CRC16"]
pub mod crc16;
#[doc = "RC RAM Control Module (FRAM)"]
pub struct RC_FRAM {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for RC_FRAM {}
impl RC_FRAM {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const rc_fram::RegisterBlock = 0x0158 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const rc_fram::RegisterBlock {
        Self::PTR
    }
}
impl Deref for RC_FRAM {
    type Target = rc_fram::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for RC_FRAM {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("RC_FRAM").finish()
    }
}
#[doc = "RC RAM Control Module (FRAM)"]
pub mod rc_fram;
#[doc = "Watchdog Timer"]
pub struct WATCHDOG_TIMER {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for WATCHDOG_TIMER {}
impl WATCHDOG_TIMER {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const watchdog_timer::RegisterBlock = 0x015c as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const watchdog_timer::RegisterBlock {
        Self::PTR
    }
}
impl Deref for WATCHDOG_TIMER {
    type Target = watchdog_timer::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for WATCHDOG_TIMER {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("WATCHDOG_TIMER").finish()
    }
}
#[doc = "Watchdog Timer"]
pub mod watchdog_timer;
#[doc = "CS Clock System"]
pub struct CS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CS {}
impl CS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const cs::RegisterBlock = 0x0160 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const cs::RegisterBlock {
        Self::PTR
    }
}
impl Deref for CS {
    type Target = cs::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for CS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("CS").finish()
    }
}
#[doc = "CS Clock System"]
pub mod cs;
#[doc = "SYS System Module"]
pub struct SYS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SYS {}
impl SYS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const sys::RegisterBlock = 0x0180 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const sys::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SYS {
    type Target = sys::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SYS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SYS").finish()
    }
}
#[doc = "SYS System Module"]
pub mod sys;
#[doc = "Shared Reference"]
pub struct SHARED_REFERENCE {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SHARED_REFERENCE {}
impl SHARED_REFERENCE {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const shared_reference::RegisterBlock = 0x01b0 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const shared_reference::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SHARED_REFERENCE {
    type Target = shared_reference::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SHARED_REFERENCE {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SHARED_REFERENCE").finish()
    }
}
#[doc = "Shared Reference"]
pub mod shared_reference;
#[doc = "Port J"]
pub struct PORT_J {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PORT_J {}
impl PORT_J {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const port_j::RegisterBlock = 0x0320 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const port_j::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PORT_J {
    type Target = port_j::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PORT_J {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PORT_J").finish()
    }
}
#[doc = "Port J"]
pub mod port_j;
#[doc = "Timer0_A3"]
pub struct TIMER_0_A3 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIMER_0_A3 {}
impl TIMER_0_A3 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const timer_0_a3::RegisterBlock = 0x0340 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const timer_0_a3::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIMER_0_A3 {
    type Target = timer_0_a3::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIMER_0_A3 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIMER_0_A3").finish()
    }
}
#[doc = "Timer0_A3"]
pub mod timer_0_a3;
#[doc = "Timer1_A3"]
pub struct TIMER_1_A3 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIMER_1_A3 {}
impl TIMER_1_A3 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const timer_1_a3::RegisterBlock = 0x0380 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const timer_1_a3::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIMER_1_A3 {
    type Target = timer_1_a3::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIMER_1_A3 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIMER_1_A3").finish()
    }
}
#[doc = "Timer1_A3"]
pub mod timer_1_a3;
#[doc = "Timer0_B7"]
pub struct TIMER_0_B7 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIMER_0_B7 {}
impl TIMER_0_B7 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const timer_0_b7::RegisterBlock = 0x03c0 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const timer_0_b7::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIMER_0_B7 {
    type Target = timer_0_b7::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIMER_0_B7 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIMER_0_B7").finish()
    }
}
#[doc = "Timer0_B7"]
pub mod timer_0_b7;
#[doc = "Timer2_A2"]
pub struct TIMER_2_A2 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIMER_2_A2 {}
impl TIMER_2_A2 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const timer_2_a2::RegisterBlock = 0x0400 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const timer_2_a2::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIMER_2_A2 {
    type Target = timer_2_a2::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIMER_2_A2 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIMER_2_A2").finish()
    }
}
#[doc = "Timer2_A2"]
pub mod timer_2_a2;
#[doc = "Capacitive_Touch_IO 0"]
pub struct CAPACITIVE_TOUCH_IO_0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CAPACITIVE_TOUCH_IO_0 {}
impl CAPACITIVE_TOUCH_IO_0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const capacitive_touch_io_0::RegisterBlock = 0x043e as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const capacitive_touch_io_0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for CAPACITIVE_TOUCH_IO_0 {
    type Target = capacitive_touch_io_0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for CAPACITIVE_TOUCH_IO_0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("CAPACITIVE_TOUCH_IO_0").finish()
    }
}
#[doc = "Capacitive_Touch_IO 0"]
pub mod capacitive_touch_io_0;
#[doc = "Timer3_A5"]
pub struct TIMER_3_A5 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIMER_3_A5 {}
impl TIMER_3_A5 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const timer_3_a5::RegisterBlock = 0x0440 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const timer_3_a5::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIMER_3_A5 {
    type Target = timer_3_a5::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIMER_3_A5 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIMER_3_A5").finish()
    }
}
#[doc = "Timer3_A5"]
pub mod timer_3_a5;
#[doc = "Capacitive_Touch_IO 1"]
pub struct CAPACITIVE_TOUCH_IO_1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CAPACITIVE_TOUCH_IO_1 {}
impl CAPACITIVE_TOUCH_IO_1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const capacitive_touch_io_1::RegisterBlock = 0x047e as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const capacitive_touch_io_1::RegisterBlock {
        Self::PTR
    }
}
impl Deref for CAPACITIVE_TOUCH_IO_1 {
    type Target = capacitive_touch_io_1::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for CAPACITIVE_TOUCH_IO_1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("CAPACITIVE_TOUCH_IO_1").finish()
    }
}
#[doc = "Capacitive_Touch_IO 1"]
pub mod capacitive_touch_io_1;
#[doc = "MPY 16 Multiplier 16 Bit Mode"]
pub struct MPY_16 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for MPY_16 {}
impl MPY_16 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const mpy_16::RegisterBlock = 0x04c0 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const mpy_16::RegisterBlock {
        Self::PTR
    }
}
impl Deref for MPY_16 {
    type Target = mpy_16::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for MPY_16 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("MPY_16").finish()
    }
}
#[doc = "MPY 16 Multiplier 16 Bit Mode"]
pub mod mpy_16;
#[doc = "MPY 32 Multiplier 32 Bit Mode"]
pub struct MPY_32 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for MPY_32 {}
impl MPY_32 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const mpy_32::RegisterBlock = 0x04d0 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const mpy_32::RegisterBlock {
        Self::PTR
    }
}
impl Deref for MPY_32 {
    type Target = mpy_32::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for MPY_32 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("MPY_32").finish()
    }
}
#[doc = "MPY 32 Multiplier 32 Bit Mode"]
pub mod mpy_32;
#[doc = "DMA"]
pub struct DMA {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for DMA {}
impl DMA {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const dma::RegisterBlock = 0x0500 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const dma::RegisterBlock {
        Self::PTR
    }
}
impl Deref for DMA {
    type Target = dma::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for DMA {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("DMA").finish()
    }
}
#[doc = "DMA"]
pub mod dma;
#[doc = "MPU"]
pub struct MPU {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for MPU {}
impl MPU {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const mpu::RegisterBlock = 0x05a0 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const mpu::RegisterBlock {
        Self::PTR
    }
}
impl Deref for MPU {
    type Target = mpu::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for MPU {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("MPU").finish()
    }
}
#[doc = "MPU"]
pub mod mpu;
#[doc = "ADC12"]
pub struct ADC12 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for ADC12 {}
impl ADC12 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const adc12::RegisterBlock = 0x0800 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const adc12::RegisterBlock {
        Self::PTR
    }
}
impl Deref for ADC12 {
    type Target = adc12::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for ADC12 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("ADC12").finish()
    }
}
#[doc = "ADC12"]
pub mod adc12;
#[doc = "Comparator E"]
pub struct COMPARATOR_E {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for COMPARATOR_E {}
impl COMPARATOR_E {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const comparator_e::RegisterBlock = 0x08c0 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const comparator_e::RegisterBlock {
        Self::PTR
    }
}
impl Deref for COMPARATOR_E {
    type Target = comparator_e::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for COMPARATOR_E {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("COMPARATOR_E").finish()
    }
}
#[doc = "Comparator E"]
pub mod comparator_e;
#[doc = "CRC32"]
pub struct CRC32 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CRC32 {}
impl CRC32 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const crc32::RegisterBlock = 0x0980 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const crc32::RegisterBlock {
        Self::PTR
    }
}
impl Deref for CRC32 {
    type Target = crc32::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for CRC32 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("CRC32").finish()
    }
}
#[doc = "CRC32"]
pub mod crc32;
#[doc = "AES Accelerator"]
pub struct AES_ACCELERATOR {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for AES_ACCELERATOR {}
impl AES_ACCELERATOR {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const aes_accelerator::RegisterBlock = 0x09c0 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const aes_accelerator::RegisterBlock {
        Self::PTR
    }
}
impl Deref for AES_ACCELERATOR {
    type Target = aes_accelerator::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for AES_ACCELERATOR {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("AES_ACCELERATOR").finish()
    }
}
#[doc = "AES Accelerator"]
pub mod aes_accelerator;
#[no_mangle]
static mut DEVICE_PERIPHERALS: bool = false;
#[doc = r"All the peripherals"]
#[allow(non_snake_case)]
pub struct Peripherals {
    #[doc = "PORT_1_2"]
    pub PORT_1_2: PORT_1_2,
    #[doc = "PORT_3_4"]
    pub PORT_3_4: PORT_3_4,
    #[doc = "PORT_5_6"]
    pub PORT_5_6: PORT_5_6,
    #[doc = "PORT_7"]
    pub PORT_7: PORT_7,
    #[doc = "PORT_9"]
    pub PORT_9: PORT_9,
    #[doc = "RTC_C_REAL_TIME_CLOCK"]
    pub RTC_C_REAL_TIME_CLOCK: RTC_C_REAL_TIME_CLOCK,
    #[doc = "USCI_A0_UART_MODE"]
    pub USCI_A0_UART_MODE: USCI_A0_UART_MODE,
    #[doc = "USCI_A0_SPI_MODE"]
    pub USCI_A0_SPI_MODE: USCI_A0_SPI_MODE,
    #[doc = "USCI_A1_UART_MODE"]
    pub USCI_A1_UART_MODE: USCI_A1_UART_MODE,
    #[doc = "USCI_A1_SPI_MODE"]
    pub USCI_A1_SPI_MODE: USCI_A1_SPI_MODE,
    #[doc = "USCI_B0_I2C_MODE"]
    pub USCI_B0_I2C_MODE: USCI_B0_I2C_MODE,
    #[doc = "USCI_B0_SPI_MODE"]
    pub USCI_B0_SPI_MODE: USCI_B0_SPI_MODE,
    #[doc = "USCI_B1_I2C_MODE"]
    pub USCI_B1_I2C_MODE: USCI_B1_I2C_MODE,
    #[doc = "USCI_B1_SPI_MODE"]
    pub USCI_B1_SPI_MODE: USCI_B1_SPI_MODE,
    #[doc = "LCD_C"]
    pub LCD_C: LCD_C,
    #[doc = "SFR"]
    pub SFR: SFR,
    #[doc = "PMM"]
    pub PMM: PMM,
    #[doc = "FRAM"]
    pub FRAM: FRAM,
    #[doc = "CRC16"]
    pub CRC16: CRC16,
    #[doc = "RC_FRAM"]
    pub RC_FRAM: RC_FRAM,
    #[doc = "WATCHDOG_TIMER"]
    pub WATCHDOG_TIMER: WATCHDOG_TIMER,
    #[doc = "CS"]
    pub CS: CS,
    #[doc = "SYS"]
    pub SYS: SYS,
    #[doc = "SHARED_REFERENCE"]
    pub SHARED_REFERENCE: SHARED_REFERENCE,
    #[doc = "PORT_J"]
    pub PORT_J: PORT_J,
    #[doc = "TIMER_0_A3"]
    pub TIMER_0_A3: TIMER_0_A3,
    #[doc = "TIMER_1_A3"]
    pub TIMER_1_A3: TIMER_1_A3,
    #[doc = "TIMER_0_B7"]
    pub TIMER_0_B7: TIMER_0_B7,
    #[doc = "TIMER_2_A2"]
    pub TIMER_2_A2: TIMER_2_A2,
    #[doc = "CAPACITIVE_TOUCH_IO_0"]
    pub CAPACITIVE_TOUCH_IO_0: CAPACITIVE_TOUCH_IO_0,
    #[doc = "TIMER_3_A5"]
    pub TIMER_3_A5: TIMER_3_A5,
    #[doc = "CAPACITIVE_TOUCH_IO_1"]
    pub CAPACITIVE_TOUCH_IO_1: CAPACITIVE_TOUCH_IO_1,
    #[doc = "MPY_16"]
    pub MPY_16: MPY_16,
    #[doc = "MPY_32"]
    pub MPY_32: MPY_32,
    #[doc = "DMA"]
    pub DMA: DMA,
    #[doc = "MPU"]
    pub MPU: MPU,
    #[doc = "ADC12"]
    pub ADC12: ADC12,
    #[doc = "COMPARATOR_E"]
    pub COMPARATOR_E: COMPARATOR_E,
    #[doc = "CRC32"]
    pub CRC32: CRC32,
    #[doc = "AES_ACCELERATOR"]
    pub AES_ACCELERATOR: AES_ACCELERATOR,
}
impl Peripherals {
    #[doc = r"Returns all the peripherals *once*"]
    #[inline]
    pub fn take() -> Option<Self> {
        msp430::interrupt::free(|_| {
            if unsafe { DEVICE_PERIPHERALS } {
                None
            } else {
                Some(unsafe { Peripherals::steal() })
            }
        })
    }
    #[doc = r"Unchecked version of `Peripherals::take`"]
    #[inline]
    pub unsafe fn steal() -> Self {
        DEVICE_PERIPHERALS = true;
        Peripherals {
            PORT_1_2: PORT_1_2 {
                _marker: PhantomData,
            },
            PORT_3_4: PORT_3_4 {
                _marker: PhantomData,
            },
            PORT_5_6: PORT_5_6 {
                _marker: PhantomData,
            },
            PORT_7: PORT_7 {
                _marker: PhantomData,
            },
            PORT_9: PORT_9 {
                _marker: PhantomData,
            },
            RTC_C_REAL_TIME_CLOCK: RTC_C_REAL_TIME_CLOCK {
                _marker: PhantomData,
            },
            USCI_A0_UART_MODE: USCI_A0_UART_MODE {
                _marker: PhantomData,
            },
            USCI_A0_SPI_MODE: USCI_A0_SPI_MODE {
                _marker: PhantomData,
            },
            USCI_A1_UART_MODE: USCI_A1_UART_MODE {
                _marker: PhantomData,
            },
            USCI_A1_SPI_MODE: USCI_A1_SPI_MODE {
                _marker: PhantomData,
            },
            USCI_B0_I2C_MODE: USCI_B0_I2C_MODE {
                _marker: PhantomData,
            },
            USCI_B0_SPI_MODE: USCI_B0_SPI_MODE {
                _marker: PhantomData,
            },
            USCI_B1_I2C_MODE: USCI_B1_I2C_MODE {
                _marker: PhantomData,
            },
            USCI_B1_SPI_MODE: USCI_B1_SPI_MODE {
                _marker: PhantomData,
            },
            LCD_C: LCD_C {
                _marker: PhantomData,
            },
            SFR: SFR {
                _marker: PhantomData,
            },
            PMM: PMM {
                _marker: PhantomData,
            },
            FRAM: FRAM {
                _marker: PhantomData,
            },
            CRC16: CRC16 {
                _marker: PhantomData,
            },
            RC_FRAM: RC_FRAM {
                _marker: PhantomData,
            },
            WATCHDOG_TIMER: WATCHDOG_TIMER {
                _marker: PhantomData,
            },
            CS: CS {
                _marker: PhantomData,
            },
            SYS: SYS {
                _marker: PhantomData,
            },
            SHARED_REFERENCE: SHARED_REFERENCE {
                _marker: PhantomData,
            },
            PORT_J: PORT_J {
                _marker: PhantomData,
            },
            TIMER_0_A3: TIMER_0_A3 {
                _marker: PhantomData,
            },
            TIMER_1_A3: TIMER_1_A3 {
                _marker: PhantomData,
            },
            TIMER_0_B7: TIMER_0_B7 {
                _marker: PhantomData,
            },
            TIMER_2_A2: TIMER_2_A2 {
                _marker: PhantomData,
            },
            CAPACITIVE_TOUCH_IO_0: CAPACITIVE_TOUCH_IO_0 {
                _marker: PhantomData,
            },
            TIMER_3_A5: TIMER_3_A5 {
                _marker: PhantomData,
            },
            CAPACITIVE_TOUCH_IO_1: CAPACITIVE_TOUCH_IO_1 {
                _marker: PhantomData,
            },
            MPY_16: MPY_16 {
                _marker: PhantomData,
            },
            MPY_32: MPY_32 {
                _marker: PhantomData,
            },
            DMA: DMA {
                _marker: PhantomData,
            },
            MPU: MPU {
                _marker: PhantomData,
            },
            ADC12: ADC12 {
                _marker: PhantomData,
            },
            COMPARATOR_E: COMPARATOR_E {
                _marker: PhantomData,
            },
            CRC32: CRC32 {
                _marker: PhantomData,
            },
            AES_ACCELERATOR: AES_ACCELERATOR {
                _marker: PhantomData,
            },
        }
    }
}
